/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.HashMap;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeData;
import org.bson.codecs.pojo.TypeWithTypeParameters;

final class MapPropertyCodecProvider
implements PropertyCodecProvider {
    MapPropertyCodecProvider() {
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> typeWithTypeParameters, PropertyCodecRegistry propertyCodecRegistry) {
        if (Map.class.isAssignableFrom(typeWithTypeParameters.getType()) && typeWithTypeParameters.getTypeParameters().size() == 2) {
            Class<?> clazz = typeWithTypeParameters.getTypeParameters().get(0).getType();
            if (!clazz.equals(String.class)) {
                throw new CodecConfigurationException(String.format("Invalid Map type. Maps MUST have string keys, found %s instead.", clazz));
            }
            try {
                return new MapCodec(typeWithTypeParameters.getType(), propertyCodecRegistry.get(typeWithTypeParameters.getTypeParameters().get(1)));
            }
            catch (CodecConfigurationException codecConfigurationException) {
                if (typeWithTypeParameters.getTypeParameters().get(1).getType() == Object.class) {
                    try {
                        return propertyCodecRegistry.get(TypeData.builder(Map.class).build());
                    }
                    catch (CodecConfigurationException codecConfigurationException2) {
                        // empty catch block
                    }
                }
                throw codecConfigurationException;
            }
        }
        return null;
    }

    private static class MapCodec<T>
    implements Codec<Map<String, T>> {
        private final Class<Map<String, T>> encoderClass;
        private final Codec<T> codec;

        MapCodec(Class<Map<String, T>> clazz, Codec<T> codec) {
            this.encoderClass = clazz;
            this.codec = codec;
        }

        @Override
        public void encode(BsonWriter bsonWriter, Map<String, T> map, EncoderContext encoderContext) {
            bsonWriter.writeStartDocument();
            for (Map.Entry<String, T> entry : map.entrySet()) {
                bsonWriter.writeName(entry.getKey());
                if (entry.getValue() == null) {
                    bsonWriter.writeNull();
                    continue;
                }
                this.codec.encode(bsonWriter, entry.getValue(), encoderContext);
            }
            bsonWriter.writeEndDocument();
        }

        @Override
        public Map<String, T> decode(BsonReader bsonReader, DecoderContext decoderContext) {
            bsonReader.readStartDocument();
            Map<String, T> map = this.getInstance();
            while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (bsonReader.getCurrentBsonType() == BsonType.NULL) {
                    map.put(bsonReader.readName(), null);
                    bsonReader.readNull();
                    continue;
                }
                map.put(bsonReader.readName(), this.codec.decode(bsonReader, decoderContext));
            }
            bsonReader.readEndDocument();
            return map;
        }

        @Override
        public Class<Map<String, T>> getEncoderClass() {
            return this.encoderClass;
        }

        private Map<String, T> getInstance() {
            if (this.encoderClass.isInterface()) {
                return new HashMap();
            }
            try {
                return this.encoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new CodecConfigurationException(exception.getMessage(), exception);
            }
        }
    }
}

