/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.DiscriminatorLookup;
import org.bson.codecs.pojo.IdPropertyModelHolder;
import org.bson.codecs.pojo.InstanceCreator;
import org.bson.codecs.pojo.LazyPropertyModelCodec;
import org.bson.codecs.pojo.PojoCodec;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.PropertyCodecRegistryImpl;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.diagnostics.Logger;
import org.bson.diagnostics.Loggers;

final class PojoCodecImpl<T>
extends PojoCodec<T> {
    private static final Logger LOGGER = Loggers.getLogger("PojoCodec");
    private static final Codec<BsonValue> BSON_VALUE_CODEC = new BsonValueCodec();
    private final ClassModel<T> classModel;
    private final CodecRegistry registry;
    private final PropertyCodecRegistry propertyCodecRegistry;
    private final DiscriminatorLookup discriminatorLookup;

    PojoCodecImpl(ClassModel<T> classModel, CodecRegistry codecRegistry, List<PropertyCodecProvider> list, DiscriminatorLookup discriminatorLookup) {
        this.classModel = classModel;
        this.registry = codecRegistry;
        this.discriminatorLookup = discriminatorLookup;
        this.propertyCodecRegistry = new PropertyCodecRegistryImpl(this, this.registry, list);
        this.specialize();
    }

    PojoCodecImpl(ClassModel<T> classModel, CodecRegistry codecRegistry, PropertyCodecRegistry propertyCodecRegistry, DiscriminatorLookup discriminatorLookup) {
        this.classModel = classModel;
        this.registry = codecRegistry;
        this.discriminatorLookup = discriminatorLookup;
        this.propertyCodecRegistry = propertyCodecRegistry;
        this.specialize();
    }

    @Override
    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        if (this.areEquivalentTypes(t.getClass(), this.classModel.getType())) {
            bsonWriter.writeStartDocument();
            this.encodeIdProperty(bsonWriter, t, encoderContext, this.classModel.getIdPropertyModelHolder());
            if (this.classModel.useDiscriminator()) {
                bsonWriter.writeString(this.classModel.getDiscriminatorKey(), this.classModel.getDiscriminator());
            }
            for (PropertyModel<?> propertyModel : this.classModel.getPropertyModels()) {
                if (propertyModel.equals(this.classModel.getIdPropertyModel())) continue;
                this.encodeProperty(bsonWriter, t, encoderContext, propertyModel);
            }
            bsonWriter.writeEndDocument();
        } else {
            this.registry.get(t.getClass()).encode(bsonWriter, t, encoderContext);
        }
    }

    @Override
    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        if (decoderContext.hasCheckedDiscriminator()) {
            InstanceCreator<T> instanceCreator = this.classModel.getInstanceCreator();
            this.decodeProperties(bsonReader, decoderContext, instanceCreator);
            return instanceCreator.getInstance();
        }
        return PojoCodecImpl.getCodecFromDocument(bsonReader, this.classModel.useDiscriminator(), this.classModel.getDiscriminatorKey(), this.registry, this.discriminatorLookup, this, this.classModel.getName()).decode(bsonReader, DecoderContext.builder().checkedDiscriminator(true).build());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.classModel.getType();
    }

    public String toString() {
        return String.format("PojoCodec<%s>", this.classModel);
    }

    @Override
    ClassModel<T> getClassModel() {
        return this.classModel;
    }

    private <S> void encodeIdProperty(BsonWriter bsonWriter, T t, EncoderContext encoderContext, IdPropertyModelHolder<S> idPropertyModelHolder) {
        if (idPropertyModelHolder.getPropertyModel() != null) {
            if (idPropertyModelHolder.getIdGenerator() == null) {
                this.encodeProperty(bsonWriter, t, encoderContext, idPropertyModelHolder.getPropertyModel());
            } else {
                S s = idPropertyModelHolder.getPropertyModel().getPropertyAccessor().get(t);
                if (s == null && encoderContext.isEncodingCollectibleDocument()) {
                    s = idPropertyModelHolder.getIdGenerator().generate();
                    try {
                        idPropertyModelHolder.getPropertyModel().getPropertyAccessor().set(t, s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.encodeValue(bsonWriter, encoderContext, idPropertyModelHolder.getPropertyModel(), s);
            }
        }
    }

    private <S> void encodeProperty(BsonWriter bsonWriter, T t, EncoderContext encoderContext, PropertyModel<S> propertyModel) {
        if (propertyModel != null && propertyModel.isReadable()) {
            S s = propertyModel.getPropertyAccessor().get(t);
            this.encodeValue(bsonWriter, encoderContext, propertyModel, s);
        }
    }

    private <S> void encodeValue(BsonWriter bsonWriter, EncoderContext encoderContext, PropertyModel<S> propertyModel, S s) {
        if (propertyModel.shouldSerialize(s)) {
            try {
                if (propertyModel.getPropertySerialization().inline()) {
                    if (s != null) {
                        new BsonDocumentWrapper<S>(s, propertyModel.getCachedCodec()).forEach((string, bsonValue) -> {
                            bsonWriter.writeName((String)string);
                            encoderContext.encodeWithChildContext(this.registry.get(bsonValue.getClass()), bsonWriter, bsonValue);
                        });
                    }
                } else {
                    bsonWriter.writeName(propertyModel.getReadName());
                    if (s == null) {
                        bsonWriter.writeNull();
                    } else {
                        encoderContext.encodeWithChildContext(propertyModel.getCachedCodec(), bsonWriter, s);
                    }
                }
            }
            catch (CodecConfigurationException codecConfigurationException) {
                throw new CodecConfigurationException(String.format("Failed to encode '%s'. Encoding '%s' errored with: %s", this.classModel.getName(), propertyModel.getReadName(), codecConfigurationException.getMessage()), codecConfigurationException);
            }
        }
    }

    private void decodeProperties(BsonReader bsonReader, DecoderContext decoderContext, InstanceCreator<T> instanceCreator) {
        PropertyModel propertyModel2 = this.classModel.getPropertyModels().stream().filter(propertyModel -> propertyModel.getPropertySerialization().inline()).findFirst().orElse(null);
        BsonDocument bsonDocument = propertyModel2 == null ? null : new BsonDocument();
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string = bsonReader.readName();
            if (this.classModel.useDiscriminator() && this.classModel.getDiscriminatorKey().equals(string)) {
                bsonReader.readString();
                continue;
            }
            this.decodePropertyModel(bsonReader, decoderContext, instanceCreator, string, this.getPropertyModelByWriteName(this.classModel, string), bsonDocument);
        }
        bsonReader.readEndDocument();
        this.setPropertyValueBsonExtraElements(instanceCreator, bsonDocument, propertyModel2);
    }

    private <S> void decodePropertyModel(BsonReader bsonReader, DecoderContext decoderContext, InstanceCreator<T> instanceCreator, String string, PropertyModel<S> propertyModel, @Nullable BsonDocument bsonDocument) {
        if (propertyModel != null) {
            this.setPropertyValue(instanceCreator, () -> {
                Object var4_4 = null;
                if (bsonReader.getCurrentBsonType() == BsonType.NULL) {
                    bsonReader.readNull();
                } else {
                    Codec codec = propertyModel.getCachedCodec();
                    if (codec == null) {
                        throw new CodecConfigurationException(String.format("Missing codec in '%s' for '%s'", this.classModel.getName(), propertyModel.getName()));
                    }
                    var4_4 = decoderContext.decodeWithChildContext(codec, bsonReader);
                }
                return var4_4;
            }, propertyModel);
        } else if (bsonDocument == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Found property not present in the ClassModel: %s", string));
            }
            bsonReader.skipValue();
        } else {
            try {
                bsonDocument.append(string, decoderContext.decodeWithChildContext(BSON_VALUE_CODEC, bsonReader));
            }
            catch (CodecConfigurationException codecConfigurationException) {
                throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding '%s' errored with: %s", this.classModel.getName(), string, codecConfigurationException.getMessage()), codecConfigurationException);
            }
        }
    }

    private <S> void setPropertyValue(InstanceCreator<T> instanceCreator, Supplier<S> supplier, PropertyModel<S> propertyModel) {
        try {
            instanceCreator.set(supplier.get(), propertyModel);
        }
        catch (BsonInvalidOperationException | CodecConfigurationException runtimeException) {
            throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding '%s' errored with: %s", this.classModel.getName(), propertyModel.getName(), runtimeException.getMessage()), runtimeException);
        }
    }

    private <S> void setPropertyValueBsonExtraElements(InstanceCreator<T> instanceCreator, @Nullable BsonDocument bsonDocument, PropertyModel<S> propertyModel) {
        if (bsonDocument != null && !bsonDocument.isEmpty() && propertyModel != null && propertyModel.isWritable()) {
            this.setPropertyValue(instanceCreator, () -> propertyModel.getCachedCodec().decode(new BsonDocumentReader(bsonDocument), DecoderContext.builder().build()), propertyModel);
        }
    }

    private void specialize() {
        this.classModel.getPropertyModels().forEach(this::cachePropertyModelCodec);
    }

    private <S> void cachePropertyModelCodec(PropertyModel<S> propertyModel) {
        if (propertyModel.getCachedCodec() == null) {
            LazyPropertyModelCodec<S> lazyPropertyModelCodec = propertyModel.getCodec() != null ? propertyModel.getCodec() : new LazyPropertyModelCodec<S>(propertyModel, this.registry, this.propertyCodecRegistry);
            propertyModel.cachedCodec(lazyPropertyModelCodec);
        }
    }

    private <S, V> boolean areEquivalentTypes(Class<S> clazz, Class<V> clazz2) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz) && Collection.class.isAssignableFrom(clazz2)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz) && Map.class.isAssignableFrom(clazz2);
    }

    @Nullable
    static <C> Codec<C> getCodecFromDocument(BsonReader bsonReader, boolean bl, String string, CodecRegistry codecRegistry, DiscriminatorLookup discriminatorLookup, @Nullable Codec<C> codec, String string2) {
        Codec<Object> codec2 = codec;
        if (bl) {
            BsonReaderMark bsonReaderMark = bsonReader.getMark();
            bsonReader.readStartDocument();
            boolean bl2 = false;
            while (!bl2 && bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                String string3 = bsonReader.readName();
                if (string.equals(string3)) {
                    bl2 = true;
                    try {
                        Class<?> clazz = discriminatorLookup.lookup(bsonReader.readString());
                        if (codec2 != null && codec2.getEncoderClass().equals(clazz)) continue;
                        codec2 = codecRegistry.get(clazz);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding errored with: %s", string2, exception.getMessage()), exception);
                    }
                }
                bsonReader.skipValue();
            }
            bsonReaderMark.reset();
        }
        return codec2;
    }

    private PropertyModel<?> getPropertyModelByWriteName(ClassModel<T> classModel, String string) {
        for (PropertyModel<?> propertyModel : classModel.getPropertyModels()) {
            if (!propertyModel.isWritable() || !propertyModel.getWriteName().equals(string)) continue;
            return propertyModel;
        }
        return null;
    }

    @Override
    DiscriminatorLookup getDiscriminatorLookup() {
        return this.discriminatorLookup;
    }
}

