/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.AutomaticPojoCodec;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.DiscriminatorLookup;
import org.bson.codecs.pojo.LazyPropertyModelCodec;
import org.bson.codecs.pojo.PojoCodec;
import org.bson.codecs.pojo.PojoCodecImpl;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.TypeParameterMap;
import org.bson.diagnostics.Logger;
import org.bson.diagnostics.Loggers;

public final class PojoCodecProvider
implements CodecProvider {
    static final Logger LOGGER = Loggers.getLogger("codecs.pojo");
    private final boolean automatic;
    private final Map<Class<?>, ClassModel<?>> classModels;
    private final Set<String> packages;
    private final List<Convention> conventions;
    private final DiscriminatorLookup discriminatorLookup;
    private final List<PropertyCodecProvider> propertyCodecProviders;

    private PojoCodecProvider(boolean bl, Map<Class<?>, ClassModel<?>> map, Set<String> set, List<Convention> list, List<PropertyCodecProvider> list2) {
        this.automatic = bl;
        this.classModels = map;
        this.packages = set;
        this.conventions = list;
        this.discriminatorLookup = new DiscriminatorLookup(map, set);
        this.propertyCodecProviders = list2;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        return this.createCodec(clazz, codecRegistry);
    }

    private <T> PojoCodec<T> createCodec(Class<T> clazz, CodecRegistry codecRegistry) {
        ClassModel<Object> classModel = this.classModels.get(clazz);
        if (classModel != null) {
            return PojoCodecProvider.createCodec(classModel, codecRegistry, this.propertyCodecProviders, this.discriminatorLookup);
        }
        if (this.automatic || clazz.getPackage() != null && this.packages.contains(clazz.getPackage().getName())) {
            try {
                classModel = PojoCodecProvider.createClassModel(clazz, this.conventions);
                if (clazz.isInterface() || !classModel.getPropertyModels().isEmpty()) {
                    this.discriminatorLookup.addClassModel(classModel);
                    return new AutomaticPojoCodec<Object>(PojoCodecProvider.createCodec(classModel, codecRegistry, this.propertyCodecProviders, this.discriminatorLookup));
                }
            }
            catch (Exception exception) {
                LOGGER.warn(String.format("Cannot use '%s' with the PojoCodec.", clazz.getSimpleName()), exception);
                return null;
            }
        }
        return null;
    }

    private static <T> PojoCodec<T> createCodec(ClassModel<T> classModel, CodecRegistry codecRegistry, List<PropertyCodecProvider> list, DiscriminatorLookup discriminatorLookup) {
        return PojoCodecProvider.shouldSpecialize(classModel) ? new PojoCodecImpl<T>(classModel, codecRegistry, list, discriminatorLookup) : new LazyPropertyModelCodec.NeedSpecializationCodec<T>(classModel, discriminatorLookup, codecRegistry);
    }

    private static <T> ClassModel<T> createClassModel(Class<T> clazz, List<Convention> list) {
        ClassModelBuilder<T> classModelBuilder = ClassModel.builder(clazz);
        if (list != null) {
            classModelBuilder.conventions(list);
        }
        return classModelBuilder.build();
    }

    private static boolean shouldSpecialize(ClassModel<?> classModel) {
        if (!classModel.hasTypeParameters()) {
            return true;
        }
        for (Map.Entry<String, TypeParameterMap> entry : classModel.getPropertyNameToTypeParameterMap().entrySet()) {
            TypeParameterMap typeParameterMap = entry.getValue();
            PropertyModel<?> propertyModel = classModel.getPropertyModel(entry.getKey());
            if (!typeParameterMap.hasTypeParameters() || propertyModel != null && propertyModel.getCodec() != null) continue;
            return false;
        }
        return true;
    }

    public static final class Builder {
        private final Set<String> packages = new HashSet<String>();
        private final Map<Class<?>, ClassModel<?>> classModels = new HashMap();
        private final List<Class<?>> clazzes = new ArrayList();
        private List<Convention> conventions = null;
        private final List<PropertyCodecProvider> propertyCodecProviders = new ArrayList<PropertyCodecProvider>();
        private boolean automatic;

        public PojoCodecProvider build() {
            List<Convention> list = this.conventions != null ? Collections.unmodifiableList(new ArrayList<Convention>(this.conventions)) : null;
            for (Class<?> clazz : this.clazzes) {
                if (this.classModels.containsKey(clazz)) continue;
                this.register(PojoCodecProvider.createClassModel(clazz, list));
            }
            return new PojoCodecProvider(this.automatic, this.classModels, this.packages, list, this.propertyCodecProviders);
        }

        public Builder automatic(boolean bl) {
            this.automatic = bl;
            return this;
        }

        public Builder conventions(List<Convention> list) {
            this.conventions = Assertions.notNull("conventions", list);
            return this;
        }

        public Builder register(Class<?> ... classArray) {
            this.clazzes.addAll(Arrays.asList(classArray));
            return this;
        }

        public Builder register(ClassModel<?> ... classModelArray) {
            Assertions.notNull("classModels", classModelArray);
            for (ClassModel<?> classModel : classModelArray) {
                this.classModels.put(classModel.getType(), classModel);
            }
            return this;
        }

        public Builder register(String ... stringArray) {
            this.packages.addAll(Arrays.asList(Assertions.notNull("packageNames", stringArray)));
            return this;
        }

        public Builder register(PropertyCodecProvider ... propertyCodecProviderArray) {
            this.propertyCodecProviders.addAll(Arrays.asList(Assertions.notNull("providers", propertyCodecProviderArray)));
            return this;
        }

        private Builder() {
        }
    }
}

