/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyAccessor;
import org.bson.codecs.pojo.PropertyMetadata;

final class PropertyAccessorImpl<T>
implements PropertyAccessor<T> {
    private final PropertyMetadata<T> propertyMetadata;

    PropertyAccessorImpl(PropertyMetadata<T> propertyMetadata) {
        this.propertyMetadata = propertyMetadata;
    }

    @Override
    public <S> T get(S s) {
        try {
            if (this.propertyMetadata.isSerializable()) {
                if (this.propertyMetadata.getGetter() != null) {
                    return (T)this.propertyMetadata.getGetter().invoke(s, new Object[0]);
                }
                return (T)this.propertyMetadata.getField().get(s);
            }
            throw this.getError(null);
        }
        catch (Exception exception) {
            throw this.getError(exception);
        }
    }

    @Override
    public <S> void set(S s, T t) {
        try {
            if (this.propertyMetadata.isDeserializable()) {
                if (this.propertyMetadata.getSetter() != null) {
                    this.propertyMetadata.getSetter().invoke(s, t);
                } else {
                    this.propertyMetadata.getField().set(s, t);
                }
            }
        }
        catch (Exception exception) {
            throw this.setError(exception);
        }
    }

    PropertyMetadata<T> getPropertyMetadata() {
        return this.propertyMetadata;
    }

    private CodecConfigurationException getError(Exception exception) {
        return new CodecConfigurationException(String.format("Unable to get value for property '%s' in %s", this.propertyMetadata.getName(), this.propertyMetadata.getDeclaringClassName()), exception);
    }

    private CodecConfigurationException setError(Exception exception) {
        return new CodecConfigurationException(String.format("Unable to set value for property '%s' in %s", this.propertyMetadata.getName(), this.propertyMetadata.getDeclaringClassName()), exception);
    }
}

