/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Objects;
import org.bson.BsonType;
import org.bson.codecs.Codec;
import org.bson.codecs.pojo.PropertyAccessor;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.PropertySerialization;
import org.bson.codecs.pojo.TypeData;

public final class PropertyModel<T> {
    private final String name;
    private final String readName;
    private final String writeName;
    private final TypeData<T> typeData;
    private final Codec<T> codec;
    private final PropertySerialization<T> propertySerialization;
    private final Boolean useDiscriminator;
    private final PropertyAccessor<T> propertyAccessor;
    private final String error;
    private volatile Codec<T> cachedCodec;
    private final BsonType bsonRepresentation;

    PropertyModel(String string, String string2, String string3, TypeData<T> typeData, Codec<T> codec, PropertySerialization<T> propertySerialization, Boolean bl, PropertyAccessor<T> propertyAccessor, String string4, BsonType bsonType) {
        this.name = string;
        this.readName = string2;
        this.writeName = string3;
        this.typeData = typeData;
        this.codec = codec;
        this.cachedCodec = codec;
        this.propertySerialization = propertySerialization;
        this.useDiscriminator = bl;
        this.propertyAccessor = propertyAccessor;
        this.error = string4;
        this.bsonRepresentation = bsonType;
    }

    public static <T> PropertyModelBuilder<T> builder() {
        return new PropertyModelBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getWriteName() {
        return this.writeName;
    }

    public String getReadName() {
        return this.readName;
    }

    public boolean isWritable() {
        return this.writeName != null;
    }

    public boolean isReadable() {
        return this.readName != null;
    }

    public TypeData<T> getTypeData() {
        return this.typeData;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public BsonType getBsonRepresentation() {
        return this.bsonRepresentation;
    }

    public boolean shouldSerialize(T t) {
        return this.propertySerialization.shouldSerialize(t);
    }

    public PropertyAccessor<T> getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public Boolean useDiscriminator() {
        return this.useDiscriminator;
    }

    public String toString() {
        return "PropertyModel{propertyName='" + this.name + "', readName='" + this.readName + "', writeName='" + this.writeName + "', typeData=" + this.typeData + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PropertyModel propertyModel = (PropertyModel)object;
        if (this.getName() != null ? !this.getName().equals(propertyModel.getName()) : propertyModel.getName() != null) {
            return false;
        }
        if (this.getReadName() != null ? !this.getReadName().equals(propertyModel.getReadName()) : propertyModel.getReadName() != null) {
            return false;
        }
        if (this.getWriteName() != null ? !this.getWriteName().equals(propertyModel.getWriteName()) : propertyModel.getWriteName() != null) {
            return false;
        }
        if (this.getTypeData() != null ? !this.getTypeData().equals(propertyModel.getTypeData()) : propertyModel.getTypeData() != null) {
            return false;
        }
        if (this.getCodec() != null ? !this.getCodec().equals(propertyModel.getCodec()) : propertyModel.getCodec() != null) {
            return false;
        }
        if (this.getPropertySerialization() != null ? !this.getPropertySerialization().equals(propertyModel.getPropertySerialization()) : propertyModel.getPropertySerialization() != null) {
            return false;
        }
        if (!Objects.equals(this.useDiscriminator, propertyModel.useDiscriminator)) {
            return false;
        }
        if (this.getPropertyAccessor() != null ? !this.getPropertyAccessor().equals(propertyModel.getPropertyAccessor()) : propertyModel.getPropertyAccessor() != null) {
            return false;
        }
        if (this.getError() != null ? !this.getError().equals(propertyModel.getError()) : propertyModel.getError() != null) {
            return false;
        }
        return !(this.getCachedCodec() != null ? !this.getCachedCodec().equals(propertyModel.getCachedCodec()) : propertyModel.getCachedCodec() != null);
    }

    public int hashCode() {
        int n = this.getName() != null ? this.getName().hashCode() : 0;
        n = 31 * n + (this.getReadName() != null ? this.getReadName().hashCode() : 0);
        n = 31 * n + (this.getWriteName() != null ? this.getWriteName().hashCode() : 0);
        n = 31 * n + (this.getTypeData() != null ? this.getTypeData().hashCode() : 0);
        n = 31 * n + (this.getCodec() != null ? this.getCodec().hashCode() : 0);
        n = 31 * n + (this.getPropertySerialization() != null ? this.getPropertySerialization().hashCode() : 0);
        n = 31 * n + (this.useDiscriminator != null ? this.useDiscriminator.hashCode() : 0);
        n = 31 * n + (this.getPropertyAccessor() != null ? this.getPropertyAccessor().hashCode() : 0);
        n = 31 * n + (this.getError() != null ? this.getError().hashCode() : 0);
        n = 31 * n + (this.getCachedCodec() != null ? this.getCachedCodec().hashCode() : 0);
        return n;
    }

    boolean hasError() {
        return this.error != null;
    }

    String getError() {
        return this.error;
    }

    PropertySerialization<T> getPropertySerialization() {
        return this.propertySerialization;
    }

    void cachedCodec(Codec<T> codec) {
        this.cachedCodec = codec;
    }

    Codec<T> getCachedCodec() {
        return this.cachedCodec;
    }
}

