/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class PropertyReflectionUtils {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";

    private PropertyReflectionUtils() {
    }

    static boolean isGetter(Method method) {
        if (method.getParameterCount() > 0) {
            return false;
        }
        if (method.getName().startsWith(GET_PREFIX) && method.getName().length() > GET_PREFIX.length()) {
            return Character.isUpperCase(method.getName().charAt(GET_PREFIX.length()));
        }
        if (method.getName().startsWith(IS_PREFIX) && method.getName().length() > IS_PREFIX.length()) {
            return Character.isUpperCase(method.getName().charAt(IS_PREFIX.length()));
        }
        return false;
    }

    static boolean isSetter(Method method) {
        if (method.getName().startsWith(SET_PREFIX) && method.getName().length() > SET_PREFIX.length() && method.getParameterCount() == 1) {
            return Character.isUpperCase(method.getName().charAt(SET_PREFIX.length()));
        }
        return false;
    }

    static String toPropertyName(Method method) {
        String string;
        String string2 = string.substring((string = method.getName()).startsWith(IS_PREFIX) ? 2 : 3);
        char[] cArray = string2.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static PropertyMethods getPropertyMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        ArrayList<Method> arrayList2 = new ArrayList<Method>();
        for (Class<?> genericDeclaration : clazz.getInterfaces()) {
            for (Method method : genericDeclaration.getDeclaredMethods()) {
                if (!method.isDefault()) continue;
                PropertyReflectionUtils.verifyAddMethodToList(method, arrayList2, arrayList);
            }
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
            PropertyReflectionUtils.verifyAddMethodToList((Method)genericDeclaration, arrayList2, arrayList);
        }
        return new PropertyMethods(arrayList2, arrayList);
    }

    private static void verifyAddMethodToList(Method method, List<Method> list, List<Method> list2) {
        if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.isBridge()) {
            if (PropertyReflectionUtils.isGetter(method)) {
                list.add(method);
            } else if (PropertyReflectionUtils.isSetter(method)) {
                list2.add(method);
            }
        }
    }

    static class PropertyMethods {
        private final Collection<Method> getterMethods;
        private final Collection<Method> setterMethods;

        PropertyMethods(Collection<Method> collection, Collection<Method> collection2) {
            this.getterMethods = collection;
            this.setterMethods = collection2;
        }

        Collection<Method> getGetterMethods() {
            return this.getterMethods;
        }

        Collection<Method> getSetterMethods() {
            return this.setterMethods;
        }
    }
}

