/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.PropertyReflectionUtils;
import org.bson.codecs.pojo.TypeWithTypeParameters;

final class TypeData<T>
implements TypeWithTypeParameters<T> {
    private final Class<T> type;
    private final List<TypeData<?>> typeParameters;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASS_MAP;

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder(Assertions.notNull("type", clazz));
    }

    public static TypeData<?> newInstance(Method method) {
        if (PropertyReflectionUtils.isGetter(method)) {
            return TypeData.newInstance(method.getGenericReturnType(), method.getReturnType());
        }
        return TypeData.newInstance(method.getGenericParameterTypes()[0], method.getParameterTypes()[0]);
    }

    public static TypeData<?> newInstance(Field field) {
        return TypeData.newInstance(field.getGenericType(), field.getType());
    }

    public static <T> TypeData<T> newInstance(Type type, Class<T> clazz) {
        Builder<T> builder = TypeData.builder(clazz);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type type2 : parameterizedType.getActualTypeArguments()) {
                TypeData.getNestedTypeData(builder, type2);
            }
        }
        return builder.build();
    }

    private static <T> void getNestedTypeData(Builder<T> builder, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Builder<T> builder2 = TypeData.builder((Class)parameterizedType.getRawType());
            for (Type type2 : parameterizedType.getActualTypeArguments()) {
                TypeData.getNestedTypeData(builder2, type2);
            }
            builder.addTypeParameter(builder2.build());
        } else if (type instanceof WildcardType) {
            builder.addTypeParameter(TypeData.builder((Class)((WildcardType)type).getUpperBounds()[0]).build());
        } else if (type instanceof TypeVariable) {
            builder.addTypeParameter(TypeData.builder(Object.class).build());
        } else if (type instanceof Class) {
            builder.addTypeParameter(TypeData.builder((Class)type).build());
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public List<TypeData<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        String string = this.typeParameters.isEmpty() ? "" : ", typeParameters=[" + TypeData.nestedTypeParameters(this.typeParameters) + "]";
        return "TypeData{type=" + this.type.getSimpleName() + string + "}";
    }

    private static String nestedTypeParameters(List<TypeData<?>> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = list.size();
        for (TypeData<?> typeData : list) {
            ++n;
            stringBuilder.append(typeData.getType().getSimpleName());
            if (!typeData.getTypeParameters().isEmpty()) {
                stringBuilder.append(String.format("<%s>", TypeData.nestedTypeParameters(typeData.getTypeParameters())));
            }
            if (n >= n2) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeData)) {
            return false;
        }
        TypeData typeData = (TypeData)object;
        if (!this.getType().equals(typeData.getType())) {
            return false;
        }
        return this.getTypeParameters().equals(typeData.getTypeParameters());
    }

    public int hashCode() {
        int n = this.getType().hashCode();
        n = 31 * n + this.getTypeParameters().hashCode();
        return n;
    }

    private TypeData(Class<T> clazz, List<TypeData<?>> list) {
        this.type = this.boxType(clazz);
        this.typeParameters = list;
    }

    boolean isAssignableFrom(Class<?> clazz) {
        return this.type.isAssignableFrom(this.boxType(clazz));
    }

    private <S> Class<S> boxType(Class<S> clazz) {
        if (clazz.isPrimitive()) {
            return PRIMITIVE_CLASS_MAP.get(clazz);
        }
        return clazz;
    }

    static {
        HashMap hashMap = new HashMap();
        hashMap.put(Boolean.TYPE, Boolean.class);
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Double.TYPE, Double.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Void.TYPE, Void.class);
        PRIMITIVE_CLASS_MAP = hashMap;
    }

    public static final class Builder<T> {
        private final Class<T> type;
        private final List<TypeData<?>> typeParameters = new ArrayList();

        private Builder(Class<T> clazz) {
            this.type = clazz;
        }

        public <S> Builder<T> addTypeParameter(TypeData<S> typeData) {
            this.typeParameters.add(Assertions.notNull("typeParameter", typeData));
            return this;
        }

        public Builder<T> addTypeParameters(List<TypeData<?>> list) {
            Assertions.notNull("typeParameters", list);
            for (TypeData<?> typeData : list) {
                this.addTypeParameter(typeData);
            }
            return this;
        }

        public TypeData<T> build() {
            return new TypeData(this.type, Collections.unmodifiableList(this.typeParameters));
        }
    }
}

