/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.codecs.pojo.Either;

final class TypeParameterMap {
    private final Map<Integer, Either<Integer, TypeParameterMap>> propertyToClassParamIndexMap;

    static Builder builder() {
        return new Builder();
    }

    Map<Integer, Either<Integer, TypeParameterMap>> getPropertyToClassParamIndexMap() {
        return this.propertyToClassParamIndexMap;
    }

    boolean hasTypeParameters() {
        return !this.propertyToClassParamIndexMap.isEmpty();
    }

    public String toString() {
        return "TypeParameterMap{fieldToClassParamIndexMap=" + this.propertyToClassParamIndexMap + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TypeParameterMap typeParameterMap = (TypeParameterMap)object;
        return this.getPropertyToClassParamIndexMap().equals(typeParameterMap.getPropertyToClassParamIndexMap());
    }

    public int hashCode() {
        return this.getPropertyToClassParamIndexMap().hashCode();
    }

    private TypeParameterMap(Map<Integer, Either<Integer, TypeParameterMap>> map) {
        this.propertyToClassParamIndexMap = Collections.unmodifiableMap(map);
    }

    static final class Builder {
        private final Map<Integer, Either<Integer, TypeParameterMap>> propertyToClassParamIndexMap = new HashMap<Integer, Either<Integer, TypeParameterMap>>();

        private Builder() {
        }

        Builder addIndex(int n) {
            this.propertyToClassParamIndexMap.put(-1, Either.left(n));
            return this;
        }

        Builder addIndex(int n, int n2) {
            this.propertyToClassParamIndexMap.put(n, Either.left(n2));
            return this;
        }

        Builder addIndex(int n, TypeParameterMap typeParameterMap) {
            this.propertyToClassParamIndexMap.put(n, Either.right(typeParameterMap));
            return this;
        }

        TypeParameterMap build() {
            if (this.propertyToClassParamIndexMap.size() > 1 && this.propertyToClassParamIndexMap.containsKey(-1)) {
                throw new IllegalStateException("You cannot have a generic field that also has type parameters.");
            }
            return new TypeParameterMap(this.propertyToClassParamIndexMap);
        }
    }
}

