/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.record;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RepresentationConfigurable;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.bson.codecs.pojo.annotations.BsonExtraElements;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.bson.codecs.pojo.annotations.BsonRepresentation;
import org.bson.diagnostics.Logger;
import org.bson.diagnostics.Loggers;

final class RecordCodec<T extends Record>
implements Codec<T> {
    private static final Logger LOGGER = Loggers.getLogger("RecordCodec");
    private final Class<T> clazz;
    private final Constructor<?> canonicalConstructor;
    private final List<ComponentModel> componentModels;
    private final ComponentModel componentModelForId;
    private final Map<String, ComponentModel> fieldNameToComponentModel;

    RecordCodec(Class<T> clazz, List<Type> list, CodecRegistry codecRegistry) {
        if (list.size() != clazz.getTypeParameters().length) {
            throw new CodecConfigurationException("Unexpected number of type parameters for record class " + clazz);
        }
        this.clazz = Assertions.notNull("class", clazz);
        this.canonicalConstructor = Assertions.notNull("canonicalConstructor", RecordCodec.getCanonicalConstructor(clazz));
        this.componentModels = RecordCodec.getComponentModels(clazz, codecRegistry, list);
        this.fieldNameToComponentModel = this.componentModels.stream().collect(Collectors.toMap(ComponentModel::getFieldName, Function.identity()));
        this.componentModelForId = RecordCodec.getComponentModelForId(clazz, this.componentModels);
    }

    @Override
    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        bsonReader.readStartDocument();
        Object[] objectArray = new Object[this.componentModels.size()];
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string = bsonReader.readName();
            ComponentModel componentModel = this.fieldNameToComponentModel.get(string);
            if (componentModel == null) {
                bsonReader.skipValue();
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace(String.format("Found property not present in the ClassModel: %s", string));
                continue;
            }
            if (bsonReader.getCurrentBsonType() == BsonType.NULL) {
                if (!componentModel.isNullable) {
                    throw new BsonInvalidOperationException(String.format("Null value on primitive field: %s", componentModel.fieldName));
                }
                bsonReader.readNull();
                continue;
            }
            objectArray[componentModel.index] = decoderContext.decodeWithChildContext(componentModel.codec, bsonReader);
        }
        bsonReader.readEndDocument();
        try {
            return (T)((Record)this.canonicalConstructor.newInstance(objectArray));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new CodecConfigurationException(String.format("Unable to invoke canonical constructor of record class %s", this.clazz.getName()), reflectiveOperationException);
        }
    }

    @Override
    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        if (this.componentModelForId != null) {
            this.writeComponent(bsonWriter, t, this.componentModelForId);
        }
        for (ComponentModel componentModel : this.componentModels) {
            if (componentModel == this.componentModelForId) continue;
            this.writeComponent(bsonWriter, t, componentModel);
        }
        bsonWriter.writeEndDocument();
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    private void writeComponent(BsonWriter bsonWriter, T t, ComponentModel componentModel) {
        try {
            Object object = componentModel.getValue((Record)t);
            if (object != null) {
                bsonWriter.writeName(componentModel.getFieldName());
                componentModel.codec.encode(bsonWriter, object, EncoderContext.builder().build());
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new CodecConfigurationException(String.format("Unable to access value of component %s for record %s", componentModel.getComponentName(), this.clazz.getName()), reflectiveOperationException);
        }
    }

    private static <T> List<ComponentModel> getComponentModels(Class<T> clazz, CodecRegistry codecRegistry, List<Type> list) {
        RecordComponent[] recordComponentArray = clazz.getRecordComponents();
        ArrayList<ComponentModel> arrayList = new ArrayList<ComponentModel>(recordComponentArray.length);
        for (int i = 0; i < recordComponentArray.length; ++i) {
            arrayList.add(new ComponentModel(list, recordComponentArray[i], codecRegistry, i));
        }
        return arrayList;
    }

    @Nullable
    private static <T> ComponentModel getComponentModelForId(Class<T> clazz, List<ComponentModel> list) {
        List<ComponentModel> list2 = list.stream().filter(componentModel -> componentModel.getFieldName().equals("_id")).toList();
        if (list2.size() > 1) {
            throw new CodecConfigurationException(String.format("Record %s has more than one _id component", clazz.getName()));
        }
        return list2.stream().findFirst().orElse(null);
    }

    private static <T> Constructor<?> getCanonicalConstructor(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor((Class[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)String.format("Could not find canonical constructor for record %s", clazz.getName()));
        }
    }

    private static Class<?> toWrapper(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        return clazz;
    }

    private static final class ComponentModel {
        private final RecordComponent component;
        private final Codec<?> codec;
        private final int index;
        private final String fieldName;
        private final boolean isNullable;

        private ComponentModel(List<Type> list, RecordComponent recordComponent, CodecRegistry codecRegistry, int n) {
            ComponentModel.validateAnnotations(recordComponent, n);
            this.component = recordComponent;
            this.codec = ComponentModel.computeCodec(list, recordComponent, codecRegistry);
            this.index = n;
            this.fieldName = ComponentModel.computeFieldName(recordComponent);
            this.isNullable = !recordComponent.getType().isPrimitive();
        }

        String getComponentName() {
            return this.component.getName();
        }

        String getFieldName() {
            return this.fieldName;
        }

        Object getValue(Record record) throws InvocationTargetException, IllegalAccessException {
            return this.component.getAccessor().invoke((Object)record, new Object[0]);
        }

        private static Codec<?> computeCodec(List<Type> list, RecordComponent recordComponent, CodecRegistry codecRegistry) {
            Codec<?> codec;
            Object object;
            Class<?> clazz = RecordCodec.toWrapper(ComponentModel.resolveComponentType(list, recordComponent));
            Object object2 = recordComponent.getGenericType();
            if (object2 instanceof ParameterizedType) {
                object = (ParameterizedType)object2;
                codec = codecRegistry.get(clazz, ComponentModel.resolveActualTypeArguments(list, recordComponent.getDeclaringRecord(), object));
            } else {
                codec = codecRegistry.get(clazz);
            }
            Codec<Object> codec2 = codec;
            object = null;
            if (ComponentModel.isAnnotationPresentOnField(recordComponent, BsonRepresentation.class)) {
                object = ComponentModel.getAnnotationOnField(recordComponent, BsonRepresentation.class).value();
            }
            if (object != null) {
                if (codec2 instanceof RepresentationConfigurable) {
                    object2 = (RepresentationConfigurable)((Object)codec2);
                    codec2 = object2.withRepresentation((BsonType)((Object)object));
                } else {
                    throw new CodecConfigurationException(String.format("Codec for %s must implement RepresentationConfigurable to support BsonRepresentation", codec2.getEncoderClass()));
                }
            }
            return codec2;
        }

        private static Class<?> resolveComponentType(List<Type> list, RecordComponent recordComponent) {
            Class clazz;
            Type type = ComponentModel.resolveType(recordComponent.getGenericType(), list, recordComponent.getDeclaringRecord());
            return type instanceof Class ? (clazz = (Class)type) : recordComponent.getType();
        }

        private static List<Type> resolveActualTypeArguments(List<Type> list, Class<?> clazz, ParameterizedType parameterizedType) {
            return Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> ComponentModel.resolveType(type, list, clazz)).toList();
        }

        private static Type resolveType(Type type, List<Type> list, Class<?> clazz) {
            Type type2;
            if (type instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)type;
                type2 = list.get(ComponentModel.getIndexOfTypeParameter(typeVariable.getName(), clazz));
            } else {
                type2 = type;
            }
            return type2;
        }

        private static int getIndexOfTypeParameter(String string, Class<?> clazz) {
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i = 0; i < typeVariableArray.length; ++i) {
                if (!typeVariableArray[i].getName().equals(string)) continue;
                return i;
            }
            throw new CodecConfigurationException(String.format("Could not find type parameter on record %s with name %s", clazz.getName(), string));
        }

        private static String computeFieldName(RecordComponent recordComponent) {
            if (ComponentModel.isAnnotationPresentOnField(recordComponent, BsonId.class)) {
                return "_id";
            }
            if (ComponentModel.isAnnotationPresentOnField(recordComponent, BsonProperty.class)) {
                return ComponentModel.getAnnotationOnField(recordComponent, BsonProperty.class).value();
            }
            return recordComponent.getName();
        }

        private static <T extends Annotation> boolean isAnnotationPresentOnField(RecordComponent recordComponent, Class<T> clazz) {
            try {
                return recordComponent.getDeclaringRecord().getDeclaredField(recordComponent.getName()).isAnnotationPresent(clazz);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError(String.format("Unexpectedly missing the declared field for record component %s", recordComponent), noSuchFieldException);
            }
        }

        private static <T extends Annotation> boolean isAnnotationPresentOnCanonicalConstructorParameter(RecordComponent recordComponent, int n, Class<T> clazz) {
            return RecordCodec.getCanonicalConstructor(recordComponent.getDeclaringRecord()).getParameters()[n].isAnnotationPresent(clazz);
        }

        private static <T extends Annotation> T getAnnotationOnField(RecordComponent recordComponent, Class<T> clazz) {
            try {
                return recordComponent.getDeclaringRecord().getDeclaredField(recordComponent.getName()).getAnnotation(clazz);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError(String.format("Unexpectedly missing the declared field for recordComponent %s", recordComponent), noSuchFieldException);
            }
        }

        private static void validateAnnotations(RecordComponent recordComponent, int n) {
            ComponentModel.validateAnnotationNotPresentOnType(recordComponent.getDeclaringRecord(), BsonDiscriminator.class);
            ComponentModel.validateAnnotationNotPresentOnConstructor(recordComponent.getDeclaringRecord(), BsonCreator.class);
            ComponentModel.validateAnnotationNotPresentOnMethod(recordComponent.getDeclaringRecord(), BsonCreator.class);
            ComponentModel.validateAnnotationNotPresentOnFieldOrAccessor(recordComponent, BsonIgnore.class);
            ComponentModel.validateAnnotationNotPresentOnFieldOrAccessor(recordComponent, BsonExtraElements.class);
            ComponentModel.validateAnnotationOnlyOnField(recordComponent, n, BsonId.class);
            ComponentModel.validateAnnotationOnlyOnField(recordComponent, n, BsonProperty.class);
            ComponentModel.validateAnnotationOnlyOnField(recordComponent, n, BsonRepresentation.class);
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnType(Class<?> clazz, Class<T> clazz2) {
            if (clazz.isAnnotationPresent(clazz2)) {
                throw new CodecConfigurationException(String.format("Annotation '%s' not supported on records, but found on '%s'", clazz2, clazz.getName()));
            }
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnConstructor(Class<?> clazz, Class<T> clazz2) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (!constructor.isAnnotationPresent(clazz2)) continue;
                throw new CodecConfigurationException(String.format("Annotation '%s' not supported on record constructors, but found on constructor of '%s'", clazz2, clazz.getName()));
            }
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnMethod(Class<?> clazz, Class<T> clazz2) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(clazz2)) continue;
                throw new CodecConfigurationException(String.format("Annotation '%s' not supported on methods, but found on method '%s' of '%s'", clazz2, method.getName(), clazz.getName()));
            }
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnFieldOrAccessor(RecordComponent recordComponent, Class<T> clazz) {
            if (ComponentModel.isAnnotationPresentOnField(recordComponent, clazz)) {
                throw new CodecConfigurationException(String.format("Annotation '%s' is not supported on records, but found on component '%s' of record '%s'", clazz.getName(), recordComponent, recordComponent.getDeclaringRecord()));
            }
            if (recordComponent.getAccessor().isAnnotationPresent(clazz)) {
                throw new CodecConfigurationException(String.format("Annotation '%s' is not supported on records, but found on accessor for component '%s' of record '%s'", clazz.getName(), recordComponent, recordComponent.getDeclaringRecord()));
            }
        }

        private static <T extends Annotation> void validateAnnotationOnlyOnField(RecordComponent recordComponent, int n, Class<T> clazz) {
            if (!ComponentModel.isAnnotationPresentOnField(recordComponent, clazz)) {
                if (recordComponent.getAccessor().isAnnotationPresent(clazz)) {
                    throw new CodecConfigurationException(String.format("Annotation %s present on accessor but not component '%s' of record '%s'", clazz.getName(), recordComponent, recordComponent.getDeclaringRecord()));
                }
                if (ComponentModel.isAnnotationPresentOnCanonicalConstructorParameter(recordComponent, n, clazz)) {
                    throw new CodecConfigurationException(String.format("Annotation %s present on canonical constructor parameter but not component '%s' of record '%s'", clazz.getName(), recordComponent, recordComponent.getDeclaringRecord()));
                }
            }
        }
    }
}

