/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonValue;

public final class BsonUtil {
    public static BsonDocument mutableDeepCopy(BsonDocument bsonDocument) {
        BsonDocument bsonDocument2 = new BsonDocument(bsonDocument.size());
        bsonDocument.forEach((string, bsonValue) -> bsonDocument2.put((String)string, BsonUtil.mutableDeepCopy(bsonValue)));
        return bsonDocument2;
    }

    private static BsonArray mutableDeepCopy(BsonArray bsonArray) {
        BsonArray bsonArray2 = new BsonArray(bsonArray.size());
        bsonArray.forEach(bsonValue -> bsonArray2.add(BsonUtil.mutableDeepCopy(bsonValue)));
        return bsonArray2;
    }

    private static BsonBinary mutableDeepCopy(BsonBinary bsonBinary) {
        return new BsonBinary(bsonBinary.getType(), (byte[])bsonBinary.getData().clone());
    }

    private static BsonJavaScriptWithScope mutableDeepCopy(BsonJavaScriptWithScope bsonJavaScriptWithScope) {
        return new BsonJavaScriptWithScope(bsonJavaScriptWithScope.getCode(), BsonUtil.mutableDeepCopy(bsonJavaScriptWithScope.getScope()));
    }

    private static BsonValue mutableDeepCopy(BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case DOCUMENT: {
                return BsonUtil.mutableDeepCopy(bsonValue.asDocument());
            }
            case ARRAY: {
                return BsonUtil.mutableDeepCopy(bsonValue.asArray());
            }
            case BINARY: {
                return BsonUtil.mutableDeepCopy(bsonValue.asBinary());
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return BsonUtil.mutableDeepCopy(bsonValue.asJavaScriptWithScope());
            }
        }
        return bsonValue;
    }

    private BsonUtil() {
    }
}

