/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.internal.CycleDetectingCodecRegistry;
import org.bson.internal.LazyCodec;

class ChildCodecRegistry<T>
implements CodecRegistry {
    private final ChildCodecRegistry<?> parent;
    private final CycleDetectingCodecRegistry registry;
    private final Class<T> codecClass;
    private final List<Type> types;

    ChildCodecRegistry(CycleDetectingCodecRegistry cycleDetectingCodecRegistry, Class<T> clazz, List<Type> list) {
        this.codecClass = clazz;
        this.parent = null;
        this.registry = cycleDetectingCodecRegistry;
        this.types = list;
    }

    private ChildCodecRegistry(ChildCodecRegistry<?> childCodecRegistry, Class<T> clazz, List<Type> list) {
        this.parent = childCodecRegistry;
        this.codecClass = clazz;
        this.registry = childCodecRegistry.registry;
        this.types = list;
    }

    public Class<T> getCodecClass() {
        return this.codecClass;
    }

    public Optional<List<Type>> getTypes() {
        return Optional.ofNullable(this.types);
    }

    public <U> Codec<U> get(Class<U> clazz) {
        if (this.hasCycles(clazz).booleanValue()) {
            return new LazyCodec<U>(this.registry, clazz, null);
        }
        return this.registry.get(new ChildCodecRegistry<U>(this, clazz, null));
    }

    public <U> Codec<U> get(Class<U> clazz, List<Type> list) {
        Assertions.notNull("typeArguments", list);
        Assertions.isTrueArgument(String.format("typeArguments size should equal the number of type parameters in class %s, but is %d", clazz, list.size()), clazz.getTypeParameters().length == list.size());
        if (this.hasCycles(clazz).booleanValue()) {
            return new LazyCodec<U>(this.registry, clazz, list);
        }
        return this.registry.get(new ChildCodecRegistry<U>(this, clazz, list));
    }

    public <U> Codec<U> get(Class<U> clazz, CodecRegistry codecRegistry) {
        return this.get(clazz, Collections.emptyList(), codecRegistry);
    }

    public <U> Codec<U> get(Class<U> clazz, List<Type> list, CodecRegistry codecRegistry) {
        return this.registry.get(clazz, list, codecRegistry);
    }

    private <U> Boolean hasCycles(Class<U> clazz) {
        ChildCodecRegistry<?> childCodecRegistry = this;
        while (childCodecRegistry != null) {
            if (childCodecRegistry.codecClass.equals(clazz)) {
                return true;
            }
            childCodecRegistry = childCodecRegistry.parent;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChildCodecRegistry childCodecRegistry = (ChildCodecRegistry)object;
        if (!this.codecClass.equals(childCodecRegistry.codecClass)) {
            return false;
        }
        if (!Objects.equals(this.parent, childCodecRegistry.parent)) {
            return false;
        }
        return this.registry.equals(childCodecRegistry.registry);
    }

    public int hashCode() {
        int n = this.parent != null ? this.parent.hashCode() : 0;
        n = 31 * n + this.registry.hashCode();
        n = 31 * n + this.codecClass.hashCode();
        return n;
    }
}

