/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;

final class CodecCache {
    private final ConcurrentMap<CodecCacheKey, Codec<?>> codecCache = new ConcurrentHashMap();

    CodecCache() {
    }

    public <T> Codec<T> putIfAbsent(CodecCacheKey codecCacheKey, Codec<T> codec) {
        Assertions.assertNotNull(codec);
        Codec<T> codec2 = this.codecCache.putIfAbsent(codecCacheKey, codec);
        return codec2 == null ? codec : codec2;
    }

    public <T> Optional<Codec<T>> get(CodecCacheKey codecCacheKey) {
        Codec codec = (Codec)this.codecCache.get(codecCacheKey);
        return Optional.ofNullable(codec);
    }

    static final class CodecCacheKey {
        private final Class<?> clazz;
        private final List<Type> types;

        CodecCacheKey(Class<?> clazz, List<Type> list) {
            this.clazz = clazz;
            this.types = list;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CodecCacheKey codecCacheKey = (CodecCacheKey)object;
            return this.clazz.equals(codecCacheKey.clazz) && Objects.equals(this.types, codecCacheKey.types);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.types);
        }

        public String toString() {
            return "CodecCacheKey{clazz=" + this.clazz + ", types=" + this.types + '}';
        }
    }
}

