/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import java.lang.reflect.Type;
import java.util.List;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

class LazyCodec<T>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> clazz;
    private final List<Type> types;
    private volatile Codec<T> wrapped;

    LazyCodec(CodecRegistry codecRegistry, Class<T> clazz, List<Type> list) {
        this.registry = codecRegistry;
        this.clazz = clazz;
        this.types = list;
    }

    @Override
    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        this.getWrapped().encode(bsonWriter, t, encoderContext);
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    @Override
    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return this.getWrapped().decode(bsonReader, decoderContext);
    }

    private Codec<T> getWrapped() {
        if (this.wrapped == null) {
            this.wrapped = this.types == null ? this.registry.get(this.clazz) : this.registry.get(this.clazz, this.types);
        }
        return this.wrapped;
    }
}

