/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import java.math.BigDecimal;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.types.Decimal128;

public final class NumberCodecHelper {
    public static byte decodeByte(BsonReader bsonReader) {
        int n = NumberCodecHelper.decodeInt(bsonReader);
        if (n < -128 || n > 127) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Byte.", n));
        }
        return (byte)n;
    }

    public static short decodeShort(BsonReader bsonReader) {
        int n = NumberCodecHelper.decodeInt(bsonReader);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Short.", n));
        }
        return (short)n;
    }

    public static int decodeInt(BsonReader bsonReader) {
        int n;
        BsonType bsonType = bsonReader.getCurrentBsonType();
        switch (bsonType) {
            case INT32: {
                n = bsonReader.readInt32();
                break;
            }
            case INT64: {
                long l = bsonReader.readInt64();
                n = (int)l;
                if (l == (long)n) break;
                throw NumberCodecHelper.invalidConversion(Integer.class, l);
            }
            case DOUBLE: {
                double d = bsonReader.readDouble();
                n = (int)d;
                if (d == (double)n) break;
                throw NumberCodecHelper.invalidConversion(Integer.class, d);
            }
            case DECIMAL128: {
                Decimal128 decimal128 = bsonReader.readDecimal128();
                n = decimal128.intValue();
                if (decimal128.equals(new Decimal128(n))) break;
                throw NumberCodecHelper.invalidConversion(Integer.class, decimal128);
            }
            default: {
                throw new BsonInvalidOperationException(String.format("Invalid numeric type, found: %s", new Object[]{bsonType}));
            }
        }
        return n;
    }

    public static long decodeLong(BsonReader bsonReader) {
        long l;
        BsonType bsonType = bsonReader.getCurrentBsonType();
        switch (bsonType) {
            case INT32: {
                l = bsonReader.readInt32();
                break;
            }
            case INT64: {
                l = bsonReader.readInt64();
                break;
            }
            case DOUBLE: {
                double d = bsonReader.readDouble();
                l = (long)d;
                if (d == (double)l) break;
                throw NumberCodecHelper.invalidConversion(Long.class, d);
            }
            case DECIMAL128: {
                Decimal128 decimal128 = bsonReader.readDecimal128();
                l = decimal128.longValue();
                if (decimal128.equals(new Decimal128(l))) break;
                throw NumberCodecHelper.invalidConversion(Long.class, decimal128);
            }
            default: {
                throw new BsonInvalidOperationException(String.format("Invalid numeric type, found: %s", new Object[]{bsonType}));
            }
        }
        return l;
    }

    public static float decodeFloat(BsonReader bsonReader) {
        double d = NumberCodecHelper.decodeDouble(bsonReader);
        if (d < -3.4028234663852886E38 || d > 3.4028234663852886E38) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Float.", d));
        }
        return (float)d;
    }

    public static double decodeDouble(BsonReader bsonReader) {
        double d;
        BsonType bsonType = bsonReader.getCurrentBsonType();
        switch (bsonType) {
            case INT32: {
                d = bsonReader.readInt32();
                break;
            }
            case INT64: {
                long l = bsonReader.readInt64();
                d = l;
                if (l == (long)d) break;
                throw NumberCodecHelper.invalidConversion(Double.class, l);
            }
            case DOUBLE: {
                d = bsonReader.readDouble();
                break;
            }
            case DECIMAL128: {
                Decimal128 decimal128 = bsonReader.readDecimal128();
                try {
                    d = decimal128.doubleValue();
                    if (!decimal128.equals(new Decimal128(new BigDecimal(d)))) {
                        throw NumberCodecHelper.invalidConversion(Double.class, decimal128);
                    }
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw NumberCodecHelper.invalidConversion(Double.class, decimal128);
                }
            }
            default: {
                throw new BsonInvalidOperationException(String.format("Invalid numeric type, found: %s", new Object[]{bsonType}));
            }
        }
        return d;
    }

    private static <T extends Number> BsonInvalidOperationException invalidConversion(Class<T> clazz, Number number) {
        return new BsonInvalidOperationException(String.format("Could not convert `%s` to a %s without losing precision", number, clazz));
    }

    private NumberCodecHelper() {
    }
}

