/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.internal.ChildCodecRegistry;
import org.bson.internal.CodecCache;
import org.bson.internal.CycleDetectingCodecRegistry;

public final class ProvidersCodecRegistry
implements CycleDetectingCodecRegistry {
    private final List<CodecProvider> codecProviders;
    private final CodecCache codecCache = new CodecCache();

    public ProvidersCodecRegistry(List<? extends CodecProvider> list) {
        Assertions.isTrueArgument("codecProviders must not be null or empty", list != null && list.size() > 0);
        this.codecProviders = new ArrayList<CodecProvider>(list);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz) {
        return this.get(new ChildCodecRegistry<T>(this, clazz, null));
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> list) {
        Assertions.notNull("typeArguments", list);
        Assertions.isTrueArgument(String.format("typeArguments size should equal the number of type parameters in class %s, but is %d", clazz, list.size()), clazz.getTypeParameters().length == list.size());
        return this.get(new ChildCodecRegistry<T>(this, clazz, list));
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        return this.get(clazz, Collections.emptyList(), codecRegistry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> list, CodecRegistry codecRegistry) {
        for (CodecProvider codecProvider : this.codecProviders) {
            Codec<T> codec = codecProvider.get(clazz, list, codecRegistry);
            if (codec == null) continue;
            return codec;
        }
        return null;
    }

    @Override
    public <T> Codec<T> get(ChildCodecRegistry<T> childCodecRegistry) {
        CodecCache.CodecCacheKey codecCacheKey = new CodecCache.CodecCacheKey(childCodecRegistry.getCodecClass(), childCodecRegistry.getTypes().orElse(null));
        return this.codecCache.get(codecCacheKey).orElseGet(() -> {
            for (CodecProvider codecProvider : this.codecProviders) {
                Codec codec = codecProvider.get(childCodecRegistry.getCodecClass(), childCodecRegistry.getTypes().orElse(Collections.emptyList()), childCodecRegistry);
                if (codec == null) continue;
                return this.codecCache.putIfAbsent(codecCacheKey, codec);
            }
            throw new CodecConfigurationException(String.format("Can't find a codec for %s.", codecCacheKey));
        });
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProvidersCodecRegistry providersCodecRegistry = (ProvidersCodecRegistry)object;
        if (this.codecProviders.size() != providersCodecRegistry.codecProviders.size()) {
            return false;
        }
        for (int i = 0; i < this.codecProviders.size(); ++i) {
            if (this.codecProviders.get(i).getClass() == providersCodecRegistry.codecProviders.get(i).getClass()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.codecProviders.hashCode();
    }

    public String toString() {
        return "ProvidersCodecRegistry{codecProviders=" + this.codecProviders + '}';
    }
}

