/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import java.util.Arrays;
import java.util.UUID;
import org.bson.BSONException;
import org.bson.BsonBinarySubType;
import org.bson.BsonSerializationException;
import org.bson.UuidRepresentation;

public final class UuidHelper {
    private static void writeLongToArrayBigEndian(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)(0xFFL & l);
        byArray[n + 6] = (byte)(0xFFL & l >> 8);
        byArray[n + 5] = (byte)(0xFFL & l >> 16);
        byArray[n + 4] = (byte)(0xFFL & l >> 24);
        byArray[n + 3] = (byte)(0xFFL & l >> 32);
        byArray[n + 2] = (byte)(0xFFL & l >> 40);
        byArray[n + 1] = (byte)(0xFFL & l >> 48);
        byArray[n] = (byte)(0xFFL & l >> 56);
    }

    private static long readLongFromArrayBigEndian(byte[] byArray, int n) {
        long l = 0L;
        l |= 0xFFL & (long)byArray[n + 7];
        l |= (0xFFL & (long)byArray[n + 6]) << 8;
        l |= (0xFFL & (long)byArray[n + 5]) << 16;
        l |= (0xFFL & (long)byArray[n + 4]) << 24;
        l |= (0xFFL & (long)byArray[n + 3]) << 32;
        l |= (0xFFL & (long)byArray[n + 2]) << 40;
        l |= (0xFFL & (long)byArray[n + 1]) << 48;
        return l |= (0xFFL & (long)byArray[n]) << 56;
    }

    private static void reverseByteArray(byte[] byArray, int n, int n2) {
        int n3 = n;
        for (int i = n + n2 - 1; n3 < i; ++n3, --i) {
            byte by = byArray[n3];
            byArray[n3] = byArray[i];
            byArray[i] = by;
        }
    }

    public static byte[] encodeUuidToBinary(UUID uUID, UuidRepresentation uuidRepresentation) {
        byte[] byArray = new byte[16];
        UuidHelper.writeLongToArrayBigEndian(byArray, 0, uUID.getMostSignificantBits());
        UuidHelper.writeLongToArrayBigEndian(byArray, 8, uUID.getLeastSignificantBits());
        switch (uuidRepresentation) {
            case C_SHARP_LEGACY: {
                UuidHelper.reverseByteArray(byArray, 0, 4);
                UuidHelper.reverseByteArray(byArray, 4, 2);
                UuidHelper.reverseByteArray(byArray, 6, 2);
                break;
            }
            case JAVA_LEGACY: {
                UuidHelper.reverseByteArray(byArray, 0, 8);
                UuidHelper.reverseByteArray(byArray, 8, 8);
                break;
            }
            case PYTHON_LEGACY: 
            case STANDARD: {
                break;
            }
            default: {
                throw new BSONException("Unexpected UUID representation: " + (Object)((Object)uuidRepresentation));
            }
        }
        return byArray;
    }

    public static UUID decodeBinaryToUuid(byte[] byArray, byte by, UuidRepresentation uuidRepresentation) {
        if (byArray.length != 16) {
            throw new BsonSerializationException(String.format("Expected length to be 16, not %d.", byArray.length));
        }
        byte[] byArray2 = byArray;
        if (by == BsonBinarySubType.UUID_LEGACY.getValue()) {
            switch (uuidRepresentation) {
                case C_SHARP_LEGACY: {
                    byArray2 = Arrays.copyOf(byArray, 16);
                    UuidHelper.reverseByteArray(byArray2, 0, 4);
                    UuidHelper.reverseByteArray(byArray2, 4, 2);
                    UuidHelper.reverseByteArray(byArray2, 6, 2);
                    break;
                }
                case JAVA_LEGACY: {
                    byArray2 = Arrays.copyOf(byArray, 16);
                    UuidHelper.reverseByteArray(byArray2, 0, 8);
                    UuidHelper.reverseByteArray(byArray2, 8, 8);
                    break;
                }
                case PYTHON_LEGACY: {
                    break;
                }
                case STANDARD: {
                    throw new BSONException("Can not decode a subtype 3 (UUID legacy) BSON binary when the decoder is configured to use the standard UUID representation");
                }
                default: {
                    throw new BSONException("Unexpected UUID representation: " + (Object)((Object)uuidRepresentation));
                }
            }
        }
        return new UUID(UuidHelper.readLongFromArrayBigEndian(byArray2, 0), UuidHelper.readLongFromArrayBigEndian(byArray2, 8));
    }

    public static boolean isLegacyUUID(UuidRepresentation uuidRepresentation) {
        return uuidRepresentation == UuidRepresentation.JAVA_LEGACY || uuidRepresentation == UuidRepresentation.C_SHARP_LEGACY || uuidRepresentation == UuidRepresentation.PYTHON_LEGACY;
    }

    private UuidHelper() {
    }
}

