/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal.vector;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.bson.BinaryVector;
import org.bson.BsonInvalidOperationException;
import org.bson.Float32BinaryVector;
import org.bson.Int8BinaryVector;
import org.bson.PackedBitBinaryVector;
import org.bson.assertions.Assertions;

public final class BinaryVectorHelper {
    private static final ByteOrder STORED_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final String ERROR_MESSAGE_UNKNOWN_VECTOR_DATA_TYPE = "Unknown vector data type: ";
    private static final byte ZERO_PADDING = 0;
    private static final int METADATA_SIZE = 2;

    private BinaryVectorHelper() {
    }

    public static byte[] encodeVectorToBinary(BinaryVector binaryVector) {
        BinaryVector.DataType dataType = binaryVector.getDataType();
        switch (dataType) {
            case INT8: {
                return BinaryVectorHelper.encodeVector(dataType.getValue(), (byte)0, binaryVector.asInt8Vector().getData());
            }
            case PACKED_BIT: {
                PackedBitBinaryVector packedBitBinaryVector = binaryVector.asPackedBitVector();
                return BinaryVectorHelper.encodeVector(dataType.getValue(), packedBitBinaryVector.getPadding(), packedBitBinaryVector.getData());
            }
            case FLOAT32: {
                return BinaryVectorHelper.encodeVector(dataType.getValue(), binaryVector.asFloat32Vector().getData());
            }
        }
        throw Assertions.fail(ERROR_MESSAGE_UNKNOWN_VECTOR_DATA_TYPE + (Object)((Object)dataType));
    }

    public static BinaryVector decodeBinaryToVector(byte[] byArray) {
        BinaryVectorHelper.isTrue("Vector encoded array length must be at least 2, but found: " + byArray.length, byArray.length >= 2);
        BinaryVector.DataType dataType = BinaryVectorHelper.determineVectorDType(byArray[0]);
        byte by = byArray[1];
        switch (dataType) {
            case INT8: {
                return BinaryVectorHelper.decodeInt8Vector(byArray, by);
            }
            case PACKED_BIT: {
                return BinaryVectorHelper.decodePackedBitVector(byArray, by);
            }
            case FLOAT32: {
                return BinaryVectorHelper.decodeFloat32Vector(byArray, by);
            }
        }
        throw Assertions.fail(ERROR_MESSAGE_UNKNOWN_VECTOR_DATA_TYPE + (Object)((Object)dataType));
    }

    private static Float32BinaryVector decodeFloat32Vector(byte[] byArray, byte by) {
        BinaryVectorHelper.isTrue("Padding must be 0 for FLOAT32 data type, but found: " + by, by == 0);
        return BinaryVector.floatVector(BinaryVectorHelper.decodeLittleEndianFloats(byArray));
    }

    private static PackedBitBinaryVector decodePackedBitVector(byte[] byArray, byte by) {
        byte[] byArray2 = BinaryVectorHelper.extractVectorData(byArray);
        BinaryVectorHelper.isTrue("Padding must be 0 if vector is empty, but found: " + by, by == 0 || byArray2.length > 0);
        BinaryVectorHelper.isTrue("Padding must be between 0 and 7 bits, but found: " + by, by >= 0 && by <= 7);
        return BinaryVector.packedBitVector(byArray2, by);
    }

    private static Int8BinaryVector decodeInt8Vector(byte[] byArray, byte by) {
        BinaryVectorHelper.isTrue("Padding must be 0 for INT8 data type, but found: " + by, by == 0);
        byte[] byArray2 = BinaryVectorHelper.extractVectorData(byArray);
        return BinaryVector.int8Vector(byArray2);
    }

    private static byte[] extractVectorData(byte[] byArray) {
        int n = byArray.length - 2;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 2, byArray2, 0, n);
        return byArray2;
    }

    private static byte[] encodeVector(byte by, byte by2, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = by;
        byArray2[1] = by2;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        return byArray2;
    }

    private static byte[] encodeVector(byte by, float[] fArray) {
        byte[] byArray = new byte[fArray.length * 4 + 2];
        byArray[0] = by;
        byArray[1] = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(STORED_BYTE_ORDER);
        byteBuffer.position(2);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        return byArray;
    }

    private static float[] decodeLittleEndianFloats(byte[] byArray) {
        BinaryVectorHelper.isTrue("Byte array length must be a multiple of 4 for FLOAT32 data type, but found: " + byArray.length, (byArray.length - 2) % 4 == 0);
        int n = byArray.length - 2;
        int n2 = n / 4;
        float[] fArray = new float[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 2, n);
        byteBuffer.order(STORED_BYTE_ORDER);
        byteBuffer.asFloatBuffer().get(fArray);
        return fArray;
    }

    public static BinaryVector.DataType determineVectorDType(byte by) {
        BinaryVector.DataType[] dataTypeArray;
        for (BinaryVector.DataType dataType : dataTypeArray = BinaryVector.DataType.values()) {
            if (dataType.getValue() != by) continue;
            return dataType;
        }
        throw new BsonInvalidOperationException(ERROR_MESSAGE_UNKNOWN_VECTOR_DATA_TYPE + by);
    }

    private static void isTrue(String string, boolean bl) {
        if (!bl) {
            throw new BsonInvalidOperationException(string);
        }
    }
}

