/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.io.OutputBuffer;

public class BasicOutputBuffer
extends OutputBuffer {
    private byte[] buffer;
    private int position;

    public BasicOutputBuffer() {
        this(1024);
    }

    public BasicOutputBuffer(int n) {
        this.buffer = new byte[n];
    }

    public byte[] getInternalBuffer() {
        return this.buffer;
    }

    @Override
    public void write(byte[] byArray) {
        this.ensureOpen();
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) {
        this.ensureOpen();
        this.ensure(n2);
        System.arraycopy(byArray, n, this.buffer, this.position, n2);
        this.position += n2;
    }

    @Override
    public void writeByte(int n) {
        this.ensureOpen();
        this.ensure(1);
        this.buffer[this.position++] = (byte)(0xFF & n);
    }

    @Override
    protected void write(int n, int n2) {
        this.ensureOpen();
        if (n < 0) {
            throw new IllegalArgumentException(String.format("position must be >= 0 but was %d", n));
        }
        if (n > this.position - 1) {
            throw new IllegalArgumentException(String.format("position must be <= %d but was %d", this.position - 1, n));
        }
        this.buffer[n] = (byte)(0xFF & n2);
    }

    @Override
    public int getPosition() {
        this.ensureOpen();
        return this.position;
    }

    @Override
    public int getSize() {
        this.ensureOpen();
        return this.position;
    }

    @Override
    public int pipe(OutputStream outputStream) throws IOException {
        this.ensureOpen();
        outputStream.write(this.buffer, 0, this.position);
        return this.position;
    }

    @Override
    public void truncateToPosition(int n) {
        this.ensureOpen();
        if (n > this.position || n < 0) {
            throw new IllegalArgumentException();
        }
        this.position = n;
    }

    @Override
    public List<ByteBuf> getByteBuffers() {
        this.ensureOpen();
        return Arrays.asList(new ByteBufNIO(ByteBuffer.wrap(this.buffer, 0, this.position).duplicate().order(ByteOrder.LITTLE_ENDIAN)));
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    private void ensureOpen() {
        if (this.buffer == null) {
            throw new IllegalStateException("The output is closed");
        }
    }

    private void ensure(int n) {
        int n2 = this.position + n;
        if (n2 <= this.buffer.length) {
            return;
        }
        int n3 = this.buffer.length * 2;
        if (n3 < n2) {
            n3 = n2 + 128;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.buffer, 0, byArray, 0, this.position);
        this.buffer = byArray;
    }
}

