/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.bson.BsonSerializationException;
import org.bson.ByteBuf;
import org.bson.io.BsonInput;
import org.bson.io.BsonInputMark;
import org.bson.types.ObjectId;

public class ByteBufferBsonInput
implements BsonInput {
    private static final String[] ONE_BYTE_ASCII_STRINGS = new String[128];
    private ByteBuf buffer;

    public ByteBufferBsonInput(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new IllegalArgumentException("buffer can not be null");
        }
        this.buffer = byteBuf;
        byteBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int getPosition() {
        this.ensureOpen();
        return this.buffer.position();
    }

    @Override
    public byte readByte() {
        this.ensureOpen();
        this.ensureAvailable(1);
        return this.buffer.get();
    }

    @Override
    public void readBytes(byte[] byArray) {
        this.ensureOpen();
        this.ensureAvailable(byArray.length);
        this.buffer.get(byArray);
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) {
        this.ensureOpen();
        this.ensureAvailable(n2);
        this.buffer.get(byArray, n, n2);
    }

    @Override
    public long readInt64() {
        this.ensureOpen();
        this.ensureAvailable(8);
        return this.buffer.getLong();
    }

    @Override
    public double readDouble() {
        this.ensureOpen();
        this.ensureAvailable(8);
        return this.buffer.getDouble();
    }

    @Override
    public int readInt32() {
        this.ensureOpen();
        this.ensureAvailable(4);
        return this.buffer.getInt();
    }

    @Override
    public ObjectId readObjectId() {
        this.ensureOpen();
        byte[] byArray = new byte[12];
        this.readBytes(byArray);
        return new ObjectId(byArray);
    }

    @Override
    public String readString() {
        this.ensureOpen();
        int n = this.readInt32();
        if (n <= 0) {
            throw new BsonSerializationException(String.format("While decoding a BSON string found a size that is not a positive number: %d", n));
        }
        this.ensureAvailable(n);
        return this.readString(n);
    }

    @Override
    public String readCString() {
        int n = this.buffer.position();
        this.skipCString();
        int n2 = this.buffer.position() - n;
        this.buffer.position(n);
        return this.readString(n2);
    }

    private String readString(int n) {
        if (n == 2) {
            byte by = this.buffer.get();
            byte by2 = this.buffer.get();
            if (by2 != 0) {
                throw new BsonSerializationException("Found a BSON string that is not null-terminated");
            }
            if (by < 0) {
                return StandardCharsets.UTF_8.newDecoder().replacement();
            }
            return ONE_BYTE_ASCII_STRINGS[by];
        }
        byte[] byArray = new byte[n - 1];
        this.buffer.get(byArray);
        byte by = this.buffer.get();
        if (by != 0) {
            throw new BsonSerializationException("Found a BSON string that is not null-terminated");
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }

    @Override
    public void skipCString() {
        this.ensureOpen();
        boolean bl = true;
        while (bl) {
            if (!this.buffer.hasRemaining()) {
                throw new BsonSerializationException("Found a BSON string that is not null-terminated");
            }
            bl = this.buffer.get() != 0;
        }
    }

    @Override
    public void skip(int n) {
        this.ensureOpen();
        this.buffer.position(this.buffer.position() + n);
    }

    @Override
    public BsonInputMark getMark(int n) {
        return new BsonInputMark(){
            private final int mark;
            {
                this.mark = ByteBufferBsonInput.this.buffer.position();
            }

            @Override
            public void reset() {
                ByteBufferBsonInput.this.ensureOpen();
                ByteBufferBsonInput.this.buffer.position(this.mark);
            }
        };
    }

    @Override
    public boolean hasRemaining() {
        this.ensureOpen();
        return this.buffer.hasRemaining();
    }

    @Override
    public void close() {
        this.buffer.release();
        this.buffer = null;
    }

    private void ensureOpen() {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
    }

    private void ensureAvailable(int n) {
        if (this.buffer.remaining() < n) {
            throw new BsonSerializationException(String.format("While decoding a BSON document %d bytes were required, but only %d remain", n, this.buffer.remaining()));
        }
    }

    static {
        for (int i = 0; i < ONE_BYTE_ASCII_STRINGS.length; ++i) {
            ByteBufferBsonInput.ONE_BYTE_ASCII_STRINGS[i] = String.valueOf((char)i);
        }
    }
}

