/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.bson.BsonSerializationException;
import org.bson.ByteBuf;
import org.bson.io.BsonOutput;
import org.bson.types.ObjectId;

public abstract class OutputBuffer
extends OutputStream
implements BsonOutput {
    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.writeBytes(byArray, n, n2);
    }

    @Override
    public void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void writeInt32(int n) {
        this.write(n >> 0);
        this.write(n >> 8);
        this.write(n >> 16);
        this.write(n >> 24);
    }

    @Override
    public void writeInt32(int n, int n2) {
        this.write(n, n2 >> 0);
        this.write(n + 1, n2 >> 8);
        this.write(n + 2, n2 >> 16);
        this.write(n + 3, n2 >> 24);
    }

    @Override
    public void writeInt64(long l) {
        this.write((byte)(0xFFL & l >> 0));
        this.write((byte)(0xFFL & l >> 8));
        this.write((byte)(0xFFL & l >> 16));
        this.write((byte)(0xFFL & l >> 24));
        this.write((byte)(0xFFL & l >> 32));
        this.write((byte)(0xFFL & l >> 40));
        this.write((byte)(0xFFL & l >> 48));
        this.write((byte)(0xFFL & l >> 56));
    }

    @Override
    public void writeDouble(double d) {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public void writeString(String string) {
        this.writeInt(0);
        int n = this.writeCharacters(string, false);
        this.writeInt32(this.getPosition() - n - 4, n);
    }

    @Override
    public void writeCString(String string) {
        this.writeCharacters(string, true);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        this.write(objectId.toByteArray());
    }

    public int size() {
        return this.getSize();
    }

    public abstract int pipe(OutputStream var1) throws IOException;

    public abstract List<ByteBuf> getByteBuffers();

    @Override
    public abstract void truncateToPosition(int var1);

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
            this.pipe(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("should be impossible", iOException);
        }
    }

    @Override
    public void write(int n) {
        this.writeByte(n);
    }

    public void writeInt(int n) {
        this.writeInt32(n);
    }

    public String toString() {
        return this.getClass().getName() + " size: " + this.size() + " pos: " + this.getPosition();
    }

    protected abstract void write(int var1, int var2);

    public void writeLong(long l) {
        this.writeInt64(l);
    }

    private int writeCharacters(String string, boolean bl) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(string, i);
            if (bl && n == 0) {
                throw new BsonSerializationException(String.format("BSON cstring '%s' is not valid because it contains a null character at index %d", string, i));
            }
            if (n < 128) {
                this.write((byte)n);
                ++n3;
                continue;
            }
            if (n < 2048) {
                this.write((byte)(192 + (n >> 6)));
                this.write((byte)(128 + (n & 0x3F)));
                n3 += 2;
                continue;
            }
            if (n < 65536) {
                this.write((byte)(224 + (n >> 12)));
                this.write((byte)(128 + (n >> 6 & 0x3F)));
                this.write((byte)(128 + (n & 0x3F)));
                n3 += 3;
                continue;
            }
            this.write((byte)(240 + (n >> 18)));
            this.write((byte)(128 + (n >> 12 & 0x3F)));
            this.write((byte)(128 + (n >> 6 & 0x3F)));
            this.write((byte)(128 + (n & 0x3F)));
            n3 += 4;
        }
        this.write(0);
        return ++n3;
    }
}

