/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

final class DateTimeFormatter {
    private static final int DATE_STRING_LENGTH = "1970-01-01".length();

    static long parse(String string) {
        if (string.length() == DATE_STRING_LENGTH) {
            return LocalDate.parse(string, java.time.format.DateTimeFormatter.ISO_LOCAL_DATE).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        return java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)string, temporalAccessor -> Instant.from(temporalAccessor)).toEpochMilli();
    }

    static String format(long l) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.of("Z")).format(java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private DateTimeFormatter() {
    }
}

