/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class JsonObject
implements Bson {
    private final String json;

    public JsonObject(String string) {
        Assertions.notNull("Json", string);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                bl = true;
                break;
            }
            Assertions.isTrueArgument("json is a valid JSON object", Character.isWhitespace(c));
        }
        Assertions.isTrueArgument("json is a valid JSON object", bl);
        this.json = string;
    }

    public String getJson() {
        return this.json;
    }

    @Override
    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper<JsonObject>(this, codecRegistry.get(JsonObject.class));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JsonObject jsonObject = (JsonObject)object;
        return this.json.equals(jsonObject.getJson());
    }

    public int hashCode() {
        return this.json.hashCode();
    }

    public String toString() {
        return this.json;
    }
}

