/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.bson.AbstractBsonReader;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReaderMark;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.json.DateTimeFormatter;
import org.bson.json.JsonParseException;
import org.bson.json.JsonScanner;
import org.bson.json.JsonToken;
import org.bson.json.JsonTokenType;
import org.bson.json.UuidStringValidator;
import org.bson.types.Decimal128;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class JsonReader
extends AbstractBsonReader {
    private final JsonScanner scanner;
    private JsonToken pushedToken;
    private Object currentValue;

    public JsonReader(String string) {
        this(new JsonScanner(string));
    }

    public JsonReader(Reader reader) {
        this(new JsonScanner(reader));
    }

    private JsonReader(JsonScanner jsonScanner) {
        this.scanner = jsonScanner;
        this.setContext(new Context(null, BsonContextType.TOP_LEVEL));
    }

    @Override
    protected BsonBinary doReadBinaryData() {
        return (BsonBinary)this.currentValue;
    }

    @Override
    protected byte doPeekBinarySubType() {
        return this.doReadBinaryData().getType();
    }

    @Override
    protected int doPeekBinarySize() {
        return this.doReadBinaryData().getData().length;
    }

    @Override
    protected boolean doReadBoolean() {
        return (Boolean)this.currentValue;
    }

    @Override
    public BsonType readBsonType() {
        Object object;
        JsonToken jsonToken;
        if (this.isClosed()) {
            throw new IllegalStateException("This instance has been closed");
        }
        if (this.getState() == AbstractBsonReader.State.INITIAL || this.getState() == AbstractBsonReader.State.DONE || this.getState() == AbstractBsonReader.State.SCOPE_DOCUMENT) {
            this.setState(AbstractBsonReader.State.TYPE);
        }
        if (this.getState() != AbstractBsonReader.State.TYPE) {
            this.throwInvalidState("readBSONType", AbstractBsonReader.State.TYPE);
        }
        if (this.getContext().getContextType() == BsonContextType.DOCUMENT) {
            jsonToken = this.popToken();
            switch (jsonToken.getType()) {
                case STRING: 
                case UNQUOTED_STRING: {
                    this.setCurrentName(jsonToken.getValue(String.class));
                    break;
                }
                case END_OBJECT: {
                    this.setState(AbstractBsonReader.State.END_OF_DOCUMENT);
                    return BsonType.END_OF_DOCUMENT;
                }
                default: {
                    throw new JsonParseException("JSON reader was expecting a name but found '%s'.", jsonToken.getValue());
                }
            }
            JsonToken jsonToken2 = this.popToken();
            if (jsonToken2.getType() != JsonTokenType.COLON) {
                throw new JsonParseException("JSON reader was expecting ':' but found '%s'.", jsonToken2.getValue());
            }
        }
        jsonToken = this.popToken();
        if (this.getContext().getContextType() == BsonContextType.ARRAY && jsonToken.getType() == JsonTokenType.END_ARRAY) {
            this.setState(AbstractBsonReader.State.END_OF_ARRAY);
            return BsonType.END_OF_DOCUMENT;
        }
        boolean bl = false;
        switch (jsonToken.getType()) {
            case BEGIN_ARRAY: {
                this.setCurrentBsonType(BsonType.ARRAY);
                break;
            }
            case BEGIN_OBJECT: {
                this.visitExtendedJSON();
                break;
            }
            case DOUBLE: {
                this.setCurrentBsonType(BsonType.DOUBLE);
                this.currentValue = jsonToken.getValue();
                break;
            }
            case END_OF_FILE: {
                this.setCurrentBsonType(BsonType.END_OF_DOCUMENT);
                break;
            }
            case INT32: {
                this.setCurrentBsonType(BsonType.INT32);
                this.currentValue = jsonToken.getValue();
                break;
            }
            case INT64: {
                this.setCurrentBsonType(BsonType.INT64);
                this.currentValue = jsonToken.getValue();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                this.currentValue = jsonToken.getValue();
                break;
            }
            case STRING: {
                this.setCurrentBsonType(BsonType.STRING);
                this.currentValue = jsonToken.getValue();
                break;
            }
            case UNQUOTED_STRING: {
                object = jsonToken.getValue(String.class);
                if ("false".equals(object) || "true".equals(object)) {
                    this.setCurrentBsonType(BsonType.BOOLEAN);
                    this.currentValue = Boolean.parseBoolean((String)object);
                    break;
                }
                if ("Infinity".equals(object)) {
                    this.setCurrentBsonType(BsonType.DOUBLE);
                    this.currentValue = Double.POSITIVE_INFINITY;
                    break;
                }
                if ("NaN".equals(object)) {
                    this.setCurrentBsonType(BsonType.DOUBLE);
                    this.currentValue = Double.NaN;
                    break;
                }
                if ("null".equals(object)) {
                    this.setCurrentBsonType(BsonType.NULL);
                    break;
                }
                if ("undefined".equals(object)) {
                    this.setCurrentBsonType(BsonType.UNDEFINED);
                    break;
                }
                if ("MinKey".equals(object)) {
                    this.visitEmptyConstructor();
                    this.setCurrentBsonType(BsonType.MIN_KEY);
                    this.currentValue = new MinKey();
                    break;
                }
                if ("MaxKey".equals(object)) {
                    this.visitEmptyConstructor();
                    this.setCurrentBsonType(BsonType.MAX_KEY);
                    this.currentValue = new MaxKey();
                    break;
                }
                if ("BinData".equals(object)) {
                    this.setCurrentBsonType(BsonType.BINARY);
                    this.currentValue = this.visitBinDataConstructor();
                    break;
                }
                if ("Date".equals(object)) {
                    this.currentValue = this.visitDateTimeConstructorWithOutNew();
                    this.setCurrentBsonType(BsonType.STRING);
                    break;
                }
                if ("HexData".equals(object)) {
                    this.setCurrentBsonType(BsonType.BINARY);
                    this.currentValue = this.visitHexDataConstructor();
                    break;
                }
                if ("ISODate".equals(object)) {
                    this.setCurrentBsonType(BsonType.DATE_TIME);
                    this.currentValue = this.visitISODateTimeConstructor();
                    break;
                }
                if ("NumberInt".equals(object)) {
                    this.setCurrentBsonType(BsonType.INT32);
                    this.currentValue = this.visitNumberIntConstructor();
                    break;
                }
                if ("NumberLong".equals(object)) {
                    this.setCurrentBsonType(BsonType.INT64);
                    this.currentValue = this.visitNumberLongConstructor();
                    break;
                }
                if ("NumberDecimal".equals(object)) {
                    this.setCurrentBsonType(BsonType.DECIMAL128);
                    this.currentValue = this.visitNumberDecimalConstructor();
                    break;
                }
                if ("ObjectId".equals(object)) {
                    this.setCurrentBsonType(BsonType.OBJECT_ID);
                    this.currentValue = this.visitObjectIdConstructor();
                    break;
                }
                if ("Timestamp".equals(object)) {
                    this.setCurrentBsonType(BsonType.TIMESTAMP);
                    this.currentValue = this.visitTimestampConstructor();
                    break;
                }
                if ("RegExp".equals(object)) {
                    this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                    this.currentValue = this.visitRegularExpressionConstructor();
                    break;
                }
                if ("DBPointer".equals(object)) {
                    this.setCurrentBsonType(BsonType.DB_POINTER);
                    this.currentValue = this.visitDBPointerConstructor();
                    break;
                }
                if ("UUID".equals(object)) {
                    this.setCurrentBsonType(BsonType.BINARY);
                    this.currentValue = this.visitUUIDConstructor();
                    break;
                }
                if ("new".equals(object)) {
                    this.visitNew();
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new JsonParseException("JSON reader was expecting a value but found '%s'.", jsonToken.getValue());
        }
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && ((JsonToken)(object = this.popToken())).getType() != JsonTokenType.COMMA) {
            this.pushToken((JsonToken)object);
        }
        switch (this.getContext().getContextType()) {
            default: {
                this.setState(AbstractBsonReader.State.NAME);
                break;
            }
            case ARRAY: 
            case JAVASCRIPT_WITH_SCOPE: 
            case TOP_LEVEL: {
                this.setState(AbstractBsonReader.State.VALUE);
            }
        }
        return this.getCurrentBsonType();
    }

    @Override
    public Decimal128 doReadDecimal128() {
        return (Decimal128)this.currentValue;
    }

    @Override
    protected long doReadDateTime() {
        return (Long)this.currentValue;
    }

    @Override
    protected double doReadDouble() {
        return (Double)this.currentValue;
    }

    @Override
    protected void doReadEndArray() {
        JsonToken jsonToken;
        this.setContext(this.getContext().getParentContext());
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (jsonToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(jsonToken);
        }
    }

    @Override
    protected void doReadEndDocument() {
        JsonToken jsonToken;
        this.setContext(this.getContext().getParentContext());
        if (this.getContext() != null && this.getContext().getContextType() == BsonContextType.SCOPE_DOCUMENT) {
            this.setContext(this.getContext().getParentContext());
            this.verifyToken(JsonTokenType.END_OBJECT);
        }
        if (this.getContext() == null) {
            throw new JsonParseException("Unexpected end of document.");
        }
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (jsonToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(jsonToken);
        }
    }

    @Override
    protected int doReadInt32() {
        return (Integer)this.currentValue;
    }

    @Override
    protected long doReadInt64() {
        return (Long)this.currentValue;
    }

    @Override
    protected String doReadJavaScript() {
        return (String)this.currentValue;
    }

    @Override
    protected String doReadJavaScriptWithScope() {
        return (String)this.currentValue;
    }

    @Override
    protected void doReadMaxKey() {
    }

    @Override
    protected void doReadMinKey() {
    }

    @Override
    protected void doReadNull() {
    }

    @Override
    protected ObjectId doReadObjectId() {
        return (ObjectId)this.currentValue;
    }

    @Override
    protected BsonRegularExpression doReadRegularExpression() {
        return (BsonRegularExpression)this.currentValue;
    }

    @Override
    protected BsonDbPointer doReadDBPointer() {
        return (BsonDbPointer)this.currentValue;
    }

    @Override
    protected void doReadStartArray() {
        this.setContext(new Context((AbstractBsonReader.Context)this.getContext(), BsonContextType.ARRAY));
    }

    @Override
    protected void doReadStartDocument() {
        this.setContext(new Context((AbstractBsonReader.Context)this.getContext(), BsonContextType.DOCUMENT));
    }

    @Override
    protected String doReadString() {
        return (String)this.currentValue;
    }

    @Override
    protected String doReadSymbol() {
        return (String)this.currentValue;
    }

    @Override
    protected BsonTimestamp doReadTimestamp() {
        return (BsonTimestamp)this.currentValue;
    }

    @Override
    protected void doReadUndefined() {
    }

    @Override
    protected void doSkipName() {
    }

    @Override
    protected void doSkipValue() {
        switch (this.getCurrentBsonType()) {
            case ARRAY: {
                this.readStartArray();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipValue();
                }
                this.readEndArray();
                break;
            }
            case BINARY: {
                this.readBinaryData();
                break;
            }
            case BOOLEAN: {
                this.readBoolean();
                break;
            }
            case DATE_TIME: {
                this.readDateTime();
                break;
            }
            case DOCUMENT: {
                this.readStartDocument();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipName();
                    this.skipValue();
                }
                this.readEndDocument();
                break;
            }
            case DOUBLE: {
                this.readDouble();
                break;
            }
            case INT32: {
                this.readInt32();
                break;
            }
            case INT64: {
                this.readInt64();
                break;
            }
            case DECIMAL128: {
                this.readDecimal128();
                break;
            }
            case JAVASCRIPT: {
                this.readJavaScript();
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.readJavaScriptWithScope();
                this.readStartDocument();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipName();
                    this.skipValue();
                }
                this.readEndDocument();
                break;
            }
            case MAX_KEY: {
                this.readMaxKey();
                break;
            }
            case MIN_KEY: {
                this.readMinKey();
                break;
            }
            case NULL: {
                this.readNull();
                break;
            }
            case OBJECT_ID: {
                this.readObjectId();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.readRegularExpression();
                break;
            }
            case STRING: {
                this.readString();
                break;
            }
            case SYMBOL: {
                this.readSymbol();
                break;
            }
            case TIMESTAMP: {
                this.readTimestamp();
                break;
            }
            case UNDEFINED: {
                this.readUndefined();
                break;
            }
        }
    }

    private JsonToken popToken() {
        if (this.pushedToken != null) {
            JsonToken jsonToken = this.pushedToken;
            this.pushedToken = null;
            return jsonToken;
        }
        return this.scanner.nextToken();
    }

    private void pushToken(JsonToken jsonToken) {
        if (this.pushedToken != null) {
            throw new BsonInvalidOperationException("There is already a pending token.");
        }
        this.pushedToken = jsonToken;
    }

    private void verifyToken(JsonTokenType jsonTokenType) {
        JsonToken jsonToken = this.popToken();
        if (jsonTokenType != jsonToken.getType()) {
            throw new JsonParseException("JSON reader expected token type '%s' but found '%s'.", new Object[]{jsonTokenType, jsonToken.getValue()});
        }
    }

    private void verifyToken(JsonTokenType jsonTokenType, Object object) {
        JsonToken jsonToken = this.popToken();
        if (jsonTokenType != jsonToken.getType()) {
            throw new JsonParseException("JSON reader expected token type '%s' but found '%s'.", new Object[]{jsonTokenType, jsonToken.getValue()});
        }
        if (!object.equals(jsonToken.getValue())) {
            throw new JsonParseException("JSON reader expected '%s' but found '%s'.", object, jsonToken.getValue());
        }
    }

    private void verifyString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Can't be null");
        }
        JsonToken jsonToken = this.popToken();
        JsonTokenType jsonTokenType = jsonToken.getType();
        if (jsonTokenType != JsonTokenType.STRING && jsonTokenType != JsonTokenType.UNQUOTED_STRING || !string.equals(jsonToken.getValue())) {
            throw new JsonParseException("JSON reader expected '%s' but found '%s'.", string, jsonToken.getValue());
        }
    }

    private void visitNew() {
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.UNQUOTED_STRING) {
            throw new JsonParseException("JSON reader expected a type name but found '%s'.", jsonToken.getValue());
        }
        String string = jsonToken.getValue(String.class);
        if ("MinKey".equals(string)) {
            this.visitEmptyConstructor();
            this.setCurrentBsonType(BsonType.MIN_KEY);
            this.currentValue = new MinKey();
        } else if ("MaxKey".equals(string)) {
            this.visitEmptyConstructor();
            this.setCurrentBsonType(BsonType.MAX_KEY);
            this.currentValue = new MaxKey();
        } else if ("BinData".equals(string)) {
            this.currentValue = this.visitBinDataConstructor();
            this.setCurrentBsonType(BsonType.BINARY);
        } else if ("Date".equals(string)) {
            this.currentValue = this.visitDateTimeConstructor();
            this.setCurrentBsonType(BsonType.DATE_TIME);
        } else if ("HexData".equals(string)) {
            this.currentValue = this.visitHexDataConstructor();
            this.setCurrentBsonType(BsonType.BINARY);
        } else if ("ISODate".equals(string)) {
            this.currentValue = this.visitISODateTimeConstructor();
            this.setCurrentBsonType(BsonType.DATE_TIME);
        } else if ("NumberInt".equals(string)) {
            this.currentValue = this.visitNumberIntConstructor();
            this.setCurrentBsonType(BsonType.INT32);
        } else if ("NumberLong".equals(string)) {
            this.currentValue = this.visitNumberLongConstructor();
            this.setCurrentBsonType(BsonType.INT64);
        } else if ("NumberDecimal".equals(string)) {
            this.currentValue = this.visitNumberDecimalConstructor();
            this.setCurrentBsonType(BsonType.DECIMAL128);
        } else if ("ObjectId".equals(string)) {
            this.currentValue = this.visitObjectIdConstructor();
            this.setCurrentBsonType(BsonType.OBJECT_ID);
        } else if ("RegExp".equals(string)) {
            this.currentValue = this.visitRegularExpressionConstructor();
            this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
        } else if ("DBPointer".equals(string)) {
            this.currentValue = this.visitDBPointerConstructor();
            this.setCurrentBsonType(BsonType.DB_POINTER);
        } else if ("UUID".equals(string)) {
            this.currentValue = this.visitUUIDConstructor();
            this.setCurrentBsonType(BsonType.BINARY);
        } else {
            throw new JsonParseException("JSON reader expected a type name but found '%s'.", string);
        }
    }

    private void visitExtendedJSON() {
        JsonToken jsonToken = this.popToken();
        String string = jsonToken.getValue(String.class);
        JsonTokenType jsonTokenType = jsonToken.getType();
        if (jsonTokenType == JsonTokenType.STRING || jsonTokenType == JsonTokenType.UNQUOTED_STRING) {
            if ("$binary".equals(string) || "$type".equals(string)) {
                this.currentValue = this.visitBinDataExtendedJson(string);
                if (this.currentValue != null) {
                    this.setCurrentBsonType(BsonType.BINARY);
                    return;
                }
            }
            if ("$uuid".equals(string)) {
                this.currentValue = this.visitUuidExtendedJson();
                this.setCurrentBsonType(BsonType.BINARY);
                return;
            }
            if ("$regex".equals(string) || "$options".equals(string)) {
                this.currentValue = this.visitRegularExpressionExtendedJson(string);
                if (this.currentValue != null) {
                    this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                    return;
                }
            } else {
                if ("$code".equals(string)) {
                    this.visitJavaScriptExtendedJson();
                    return;
                }
                if ("$date".equals(string)) {
                    this.currentValue = this.visitDateTimeExtendedJson();
                    this.setCurrentBsonType(BsonType.DATE_TIME);
                    return;
                }
                if ("$maxKey".equals(string)) {
                    this.currentValue = this.visitMaxKeyExtendedJson();
                    this.setCurrentBsonType(BsonType.MAX_KEY);
                    return;
                }
                if ("$minKey".equals(string)) {
                    this.currentValue = this.visitMinKeyExtendedJson();
                    this.setCurrentBsonType(BsonType.MIN_KEY);
                    return;
                }
                if ("$oid".equals(string)) {
                    this.currentValue = this.visitObjectIdExtendedJson();
                    this.setCurrentBsonType(BsonType.OBJECT_ID);
                    return;
                }
                if ("$regularExpression".equals(string)) {
                    this.currentValue = this.visitNewRegularExpressionExtendedJson();
                    this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                    return;
                }
                if ("$symbol".equals(string)) {
                    this.currentValue = this.visitSymbolExtendedJson();
                    this.setCurrentBsonType(BsonType.SYMBOL);
                    return;
                }
                if ("$timestamp".equals(string)) {
                    this.currentValue = this.visitTimestampExtendedJson();
                    this.setCurrentBsonType(BsonType.TIMESTAMP);
                    return;
                }
                if ("$undefined".equals(string)) {
                    this.currentValue = this.visitUndefinedExtendedJson();
                    this.setCurrentBsonType(BsonType.UNDEFINED);
                    return;
                }
                if ("$numberLong".equals(string)) {
                    this.currentValue = this.visitNumberLongExtendedJson();
                    this.setCurrentBsonType(BsonType.INT64);
                    return;
                }
                if ("$numberInt".equals(string)) {
                    this.currentValue = this.visitNumberIntExtendedJson();
                    this.setCurrentBsonType(BsonType.INT32);
                    return;
                }
                if ("$numberDouble".equals(string)) {
                    this.currentValue = this.visitNumberDoubleExtendedJson();
                    this.setCurrentBsonType(BsonType.DOUBLE);
                    return;
                }
                if ("$numberDecimal".equals(string)) {
                    this.currentValue = this.visitNumberDecimalExtendedJson();
                    this.setCurrentBsonType(BsonType.DECIMAL128);
                    return;
                }
                if ("$dbPointer".equals(string)) {
                    this.currentValue = this.visitDbPointerExtendedJson();
                    this.setCurrentBsonType(BsonType.DB_POINTER);
                    return;
                }
            }
        }
        this.pushToken(jsonToken);
        this.setCurrentBsonType(BsonType.DOCUMENT);
    }

    private void visitEmptyConstructor() {
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.LEFT_PAREN) {
            this.verifyToken(JsonTokenType.RIGHT_PAREN);
        } else {
            this.pushToken(jsonToken);
        }
    }

    private BsonBinary visitBinDataConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected a binary subtype but found '%s'.", jsonToken.getValue());
        }
        this.verifyToken(JsonTokenType.COMMA);
        JsonToken jsonToken2 = this.popToken();
        if (jsonToken2.getType() != JsonTokenType.UNQUOTED_STRING && jsonToken2.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", jsonToken2.getValue());
        }
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        byte[] byArray = Base64.getDecoder().decode(jsonToken2.getValue(String.class));
        return new BsonBinary(jsonToken.getValue(Integer.class).byteValue(), byArray);
    }

    private BsonBinary visitUUIDConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        String string = this.readStringFromExtendedJson().replace("-", "");
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return new BsonBinary(BsonBinarySubType.UUID_STANDARD, JsonReader.decodeHex(string));
    }

    private BsonRegularExpression visitRegularExpressionConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        String string = this.readStringFromExtendedJson();
        String string2 = "";
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.COMMA) {
            string2 = this.readStringFromExtendedJson();
        } else {
            this.pushToken(jsonToken);
        }
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return new BsonRegularExpression(string, string2);
    }

    private ObjectId visitObjectIdConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        ObjectId objectId = new ObjectId(this.readStringFromExtendedJson());
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return objectId;
    }

    private BsonTimestamp visitTimestampConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected an integer but found '%s'.", jsonToken.getValue());
        }
        int n = jsonToken.getValue(Integer.class);
        this.verifyToken(JsonTokenType.COMMA);
        JsonToken jsonToken2 = this.popToken();
        if (jsonToken2.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected an integer but found '%s'.", jsonToken.getValue());
        }
        int n2 = jsonToken2.getValue(Integer.class);
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return new BsonTimestamp(n, n2);
    }

    private BsonDbPointer visitDBPointerConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        String string = this.readStringFromExtendedJson();
        this.verifyToken(JsonTokenType.COMMA);
        ObjectId objectId = new ObjectId(this.readStringFromExtendedJson());
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return new BsonDbPointer(string, objectId);
    }

    private int visitNumberIntConstructor() {
        int n;
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.INT32) {
            n = jsonToken.getValue(Integer.class);
        } else if (jsonToken.getType() == JsonTokenType.STRING) {
            n = Integer.parseInt(jsonToken.getValue(String.class));
        } else {
            throw new JsonParseException("JSON reader expected an integer or a string but found '%s'.", jsonToken.getValue());
        }
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return n;
    }

    private long visitNumberLongConstructor() {
        long l;
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.INT32 || jsonToken.getType() == JsonTokenType.INT64) {
            l = jsonToken.getValue(Long.class);
        } else if (jsonToken.getType() == JsonTokenType.STRING) {
            l = Long.parseLong(jsonToken.getValue(String.class));
        } else {
            throw new JsonParseException("JSON reader expected an integer or a string but found '%s'.", jsonToken.getValue());
        }
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return l;
    }

    private Decimal128 visitNumberDecimalConstructor() {
        Decimal128 decimal128;
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.INT32 || jsonToken.getType() == JsonTokenType.INT64 || jsonToken.getType() == JsonTokenType.DOUBLE) {
            decimal128 = jsonToken.getValue(Decimal128.class);
        } else if (jsonToken.getType() == JsonTokenType.STRING) {
            decimal128 = Decimal128.parse(jsonToken.getValue(String.class));
        } else {
            throw new JsonParseException("JSON reader expected a number or a string but found '%s'.", jsonToken.getValue());
        }
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        return decimal128;
    }

    private long visitISODateTimeConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.RIGHT_PAREN) {
            return new Date().getTime();
        }
        if (jsonToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", jsonToken.getValue());
        }
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        String string = jsonToken.getValue(String.class);
        try {
            return DateTimeFormatter.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new JsonParseException("Failed to parse string as a date: " + string, dateTimeParseException);
        }
    }

    private BsonBinary visitHexDataConstructor() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected a binary subtype but found '%s'.", jsonToken.getValue());
        }
        this.verifyToken(JsonTokenType.COMMA);
        String string = this.readStringFromExtendedJson();
        this.verifyToken(JsonTokenType.RIGHT_PAREN);
        if ((string.length() & 1) != 0) {
            string = "0" + string;
        }
        for (BsonBinarySubType bsonBinarySubType : BsonBinarySubType.values()) {
            if (bsonBinarySubType.getValue() != jsonToken.getValue(Integer.class).intValue()) continue;
            return new BsonBinary(bsonBinarySubType, JsonReader.decodeHex(string));
        }
        return new BsonBinary(JsonReader.decodeHex(string));
    }

    private long visitDateTimeConstructor() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss z", Locale.ENGLISH);
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.RIGHT_PAREN) {
            return new Date().getTime();
        }
        if (jsonToken.getType() == JsonTokenType.STRING) {
            this.verifyToken(JsonTokenType.RIGHT_PAREN);
            String string = jsonToken.getValue(String.class);
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = ((DateFormat)simpleDateFormat).parse(string, parsePosition);
            if (date != null && parsePosition.getIndex() == string.length()) {
                return date.getTime();
            }
            throw new JsonParseException("JSON reader expected a date in 'EEE MMM dd yyyy HH:mm:ss z' format but found '%s'.", string);
        }
        if (jsonToken.getType() == JsonTokenType.INT32 || jsonToken.getType() == JsonTokenType.INT64) {
            int n;
            long[] lArray;
            block8: {
                lArray = new long[7];
                n = 0;
                do {
                    if (n < lArray.length) {
                        lArray[n++] = jsonToken.getValue(Long.class);
                    }
                    if ((jsonToken = this.popToken()).getType() == JsonTokenType.RIGHT_PAREN) break block8;
                    if (jsonToken.getType() == JsonTokenType.COMMA) continue;
                    throw new JsonParseException("JSON reader expected a ',' or a ')' but found '%s'.", jsonToken.getValue());
                } while ((jsonToken = this.popToken()).getType() == JsonTokenType.INT32 || jsonToken.getType() == JsonTokenType.INT64);
                throw new JsonParseException("JSON reader expected an integer but found '%s'.", jsonToken.getValue());
            }
            if (n == 1) {
                return lArray[0];
            }
            if (n < 3 || n > 7) {
                throw new JsonParseException("JSON reader expected 1 or 3-7 integers but found %d.", n);
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.set(1, (int)lArray[0]);
            calendar.set(2, (int)lArray[1]);
            calendar.set(5, (int)lArray[2]);
            calendar.set(11, (int)lArray[3]);
            calendar.set(12, (int)lArray[4]);
            calendar.set(13, (int)lArray[5]);
            calendar.set(14, (int)lArray[6]);
            return calendar.getTimeInMillis();
        }
        throw new JsonParseException("JSON reader expected an integer or a string but found '%s'.", jsonToken.getValue());
    }

    private String visitDateTimeConstructorWithOutNew() {
        this.verifyToken(JsonTokenType.LEFT_PAREN);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.RIGHT_PAREN) {
            while (jsonToken.getType() != JsonTokenType.END_OF_FILE && (jsonToken = this.popToken()).getType() != JsonTokenType.RIGHT_PAREN) {
            }
            if (jsonToken.getType() != JsonTokenType.RIGHT_PAREN) {
                throw new JsonParseException("JSON reader expected a ')' but found '%s'.", jsonToken.getValue());
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss z", Locale.ENGLISH);
        return simpleDateFormat.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonBinary visitBinDataExtendedJson(String string) {
        Mark mark = new Mark();
        try {
            this.verifyToken(JsonTokenType.COLON);
            if (string.equals("$binary")) {
                JsonToken jsonToken = this.popToken();
                if (jsonToken.getType() == JsonTokenType.BEGIN_OBJECT) {
                    byte by;
                    byte[] byArray;
                    JsonToken jsonToken2 = this.popToken();
                    String string2 = jsonToken2.getValue(String.class);
                    if (string2.equals("base64")) {
                        this.verifyToken(JsonTokenType.COLON);
                        byArray = Base64.getDecoder().decode(this.readStringFromExtendedJson());
                        this.verifyToken(JsonTokenType.COMMA);
                        this.verifyString("subType");
                        this.verifyToken(JsonTokenType.COLON);
                        by = this.readBinarySubtypeFromExtendedJson();
                    } else if (string2.equals("subType")) {
                        this.verifyToken(JsonTokenType.COLON);
                        by = this.readBinarySubtypeFromExtendedJson();
                        this.verifyToken(JsonTokenType.COMMA);
                        this.verifyString("base64");
                        this.verifyToken(JsonTokenType.COLON);
                        byArray = Base64.getDecoder().decode(this.readStringFromExtendedJson());
                    } else {
                        throw new JsonParseException("Unexpected key for $binary: " + string2);
                    }
                    this.verifyToken(JsonTokenType.END_OBJECT);
                    this.verifyToken(JsonTokenType.END_OBJECT);
                    BsonBinary bsonBinary = new BsonBinary(by, byArray);
                    return bsonBinary;
                }
                mark.reset();
                BsonBinary bsonBinary = this.visitLegacyBinaryExtendedJson(string);
                return bsonBinary;
            }
            mark.reset();
            BsonBinary bsonBinary = this.visitLegacyBinaryExtendedJson(string);
            return bsonBinary;
        }
        finally {
            mark.discard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonBinary visitLegacyBinaryExtendedJson(String string) {
        Mark mark = new Mark();
        try {
            byte by;
            byte[] byArray;
            this.verifyToken(JsonTokenType.COLON);
            if (string.equals("$binary")) {
                byArray = Base64.getDecoder().decode(this.readStringFromExtendedJson());
                this.verifyToken(JsonTokenType.COMMA);
                this.verifyString("$type");
                this.verifyToken(JsonTokenType.COLON);
                by = this.readBinarySubtypeFromExtendedJson();
            } else {
                by = this.readBinarySubtypeFromExtendedJson();
                this.verifyToken(JsonTokenType.COMMA);
                this.verifyString("$binary");
                this.verifyToken(JsonTokenType.COLON);
                byArray = Base64.getDecoder().decode(this.readStringFromExtendedJson());
            }
            this.verifyToken(JsonTokenType.END_OBJECT);
            BsonBinary bsonBinary = new BsonBinary(by, byArray);
            return bsonBinary;
        }
        catch (NumberFormatException | JsonParseException runtimeException) {
            mark.reset();
            BsonBinary bsonBinary = null;
            return bsonBinary;
        }
        finally {
            mark.discard();
        }
    }

    private byte readBinarySubtypeFromExtendedJson() {
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.STRING && jsonToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected a string or number but found '%s'.", jsonToken.getValue());
        }
        if (jsonToken.getType() == JsonTokenType.STRING) {
            return (byte)Integer.parseInt(jsonToken.getValue(String.class), 16);
        }
        return jsonToken.getValue(Integer.class).byteValue();
    }

    private long visitDateTimeExtendedJson() {
        long l;
        this.verifyToken(JsonTokenType.COLON);
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.BEGIN_OBJECT) {
            JsonToken jsonToken2 = this.popToken();
            String string = jsonToken2.getValue(String.class);
            if (!string.equals("$numberLong")) {
                throw new JsonParseException(String.format("JSON reader expected $numberLong within $date, but found %s", string));
            }
            l = this.visitNumberLongExtendedJson();
            this.verifyToken(JsonTokenType.END_OBJECT);
        } else {
            if (jsonToken.getType() == JsonTokenType.INT32 || jsonToken.getType() == JsonTokenType.INT64) {
                l = jsonToken.getValue(Long.class);
            } else if (jsonToken.getType() == JsonTokenType.STRING) {
                String string = jsonToken.getValue(String.class);
                try {
                    l = DateTimeFormatter.parse(string);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new JsonParseException("Failed to parse string as a date", dateTimeParseException);
                }
            } else {
                throw new JsonParseException("JSON reader expected an integer or string but found '%s'.", jsonToken.getValue());
            }
            this.verifyToken(JsonTokenType.END_OBJECT);
        }
        return l;
    }

    private MaxKey visitMaxKeyExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        this.verifyToken(JsonTokenType.INT32, 1);
        this.verifyToken(JsonTokenType.END_OBJECT);
        return new MaxKey();
    }

    private MinKey visitMinKeyExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        this.verifyToken(JsonTokenType.INT32, 1);
        this.verifyToken(JsonTokenType.END_OBJECT);
        return new MinKey();
    }

    private ObjectId visitObjectIdExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        ObjectId objectId = new ObjectId(this.readStringFromExtendedJson());
        this.verifyToken(JsonTokenType.END_OBJECT);
        return objectId;
    }

    private BsonRegularExpression visitNewRegularExpressionExtendedJson() {
        String string;
        this.verifyToken(JsonTokenType.COLON);
        this.verifyToken(JsonTokenType.BEGIN_OBJECT);
        String string2 = "";
        String string3 = this.readStringKeyFromExtendedJson();
        if (string3.equals("pattern")) {
            this.verifyToken(JsonTokenType.COLON);
            string = this.readStringFromExtendedJson();
            this.verifyToken(JsonTokenType.COMMA);
            this.verifyString("options");
            this.verifyToken(JsonTokenType.COLON);
            string2 = this.readStringFromExtendedJson();
        } else if (string3.equals("options")) {
            this.verifyToken(JsonTokenType.COLON);
            string2 = this.readStringFromExtendedJson();
            this.verifyToken(JsonTokenType.COMMA);
            this.verifyString("pattern");
            this.verifyToken(JsonTokenType.COLON);
            string = this.readStringFromExtendedJson();
        } else {
            throw new JsonParseException("Expected 'pattern' and 'options' fields in $regularExpression document but found " + string3);
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        this.verifyToken(JsonTokenType.END_OBJECT);
        return new BsonRegularExpression(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonRegularExpression visitRegularExpressionExtendedJson(String string) {
        Mark mark = new Mark();
        try {
            String string2;
            this.verifyToken(JsonTokenType.COLON);
            String string3 = "";
            if (string.equals("$regex")) {
                string2 = this.readStringFromExtendedJson();
                this.verifyToken(JsonTokenType.COMMA);
                this.verifyString("$options");
                this.verifyToken(JsonTokenType.COLON);
                string3 = this.readStringFromExtendedJson();
            } else {
                string3 = this.readStringFromExtendedJson();
                this.verifyToken(JsonTokenType.COMMA);
                this.verifyString("$regex");
                this.verifyToken(JsonTokenType.COLON);
                string2 = this.readStringFromExtendedJson();
            }
            this.verifyToken(JsonTokenType.END_OBJECT);
            BsonRegularExpression bsonRegularExpression = new BsonRegularExpression(string2, string3);
            return bsonRegularExpression;
        }
        catch (JsonParseException jsonParseException) {
            mark.reset();
            BsonRegularExpression bsonRegularExpression = null;
            return bsonRegularExpression;
        }
        finally {
            mark.discard();
        }
    }

    private String readStringFromExtendedJson() {
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", jsonToken.getValue());
        }
        return jsonToken.getValue(String.class);
    }

    private String visitSymbolExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        String string = this.readStringFromExtendedJson();
        this.verifyToken(JsonTokenType.END_OBJECT);
        return string;
    }

    private BsonTimestamp visitTimestampExtendedJson() {
        int n;
        int n2;
        this.verifyToken(JsonTokenType.COLON);
        this.verifyToken(JsonTokenType.BEGIN_OBJECT);
        String string = this.readStringKeyFromExtendedJson();
        if (string.equals("t")) {
            this.verifyToken(JsonTokenType.COLON);
            n2 = this.readIntFromExtendedJson();
            this.verifyToken(JsonTokenType.COMMA);
            this.verifyString("i");
            this.verifyToken(JsonTokenType.COLON);
            n = this.readIntFromExtendedJson();
        } else if (string.equals("i")) {
            this.verifyToken(JsonTokenType.COLON);
            n = this.readIntFromExtendedJson();
            this.verifyToken(JsonTokenType.COMMA);
            this.verifyString("t");
            this.verifyToken(JsonTokenType.COLON);
            n2 = this.readIntFromExtendedJson();
        } else {
            throw new JsonParseException("Expected 't' and 'i' fields in $timestamp document but found " + string);
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        this.verifyToken(JsonTokenType.END_OBJECT);
        return new BsonTimestamp(n2, n);
    }

    private int readIntFromExtendedJson() {
        int n;
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() == JsonTokenType.INT32) {
            n = jsonToken.getValue(Integer.class);
        } else if (jsonToken.getType() == JsonTokenType.INT64) {
            n = jsonToken.getValue(Long.class).intValue();
        } else {
            throw new JsonParseException("JSON reader expected an integer but found '%s'.", jsonToken.getValue());
        }
        return n;
    }

    private BsonBinary visitUuidExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        String string = this.readStringFromExtendedJson();
        this.verifyToken(JsonTokenType.END_OBJECT);
        try {
            UuidStringValidator.validate(string);
            return new BsonBinary(UUID.fromString(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonParseException(illegalArgumentException);
        }
    }

    private void visitJavaScriptExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        String string = this.readStringFromExtendedJson();
        JsonToken jsonToken = this.popToken();
        switch (jsonToken.getType()) {
            case COMMA: {
                this.verifyString("$scope");
                this.verifyToken(JsonTokenType.COLON);
                this.setState(AbstractBsonReader.State.VALUE);
                this.currentValue = string;
                this.setCurrentBsonType(BsonType.JAVASCRIPT_WITH_SCOPE);
                this.setContext(new Context((AbstractBsonReader.Context)this.getContext(), BsonContextType.SCOPE_DOCUMENT));
                break;
            }
            case END_OBJECT: {
                this.currentValue = string;
                this.setCurrentBsonType(BsonType.JAVASCRIPT);
                break;
            }
            default: {
                throw new JsonParseException("JSON reader expected ',' or '}' but found '%s'.", jsonToken);
            }
        }
    }

    private BsonUndefined visitUndefinedExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        JsonToken jsonToken = this.popToken();
        if (!jsonToken.getValue(String.class).equals("true")) {
            throw new JsonParseException("JSON reader requires $undefined to have the value of true but found '%s'.", jsonToken.getValue());
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        return new BsonUndefined();
    }

    private Long visitNumberLongExtendedJson() {
        Long l;
        this.verifyToken(JsonTokenType.COLON);
        String string = this.readStringFromExtendedJson();
        try {
            l = Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException(String.format("Exception converting value '%s' to type %s", string, Long.class.getName()), numberFormatException);
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        return l;
    }

    private Integer visitNumberIntExtendedJson() {
        Integer n;
        this.verifyToken(JsonTokenType.COLON);
        String string = this.readStringFromExtendedJson();
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException(String.format("Exception converting value '%s' to type %s", string, Integer.class.getName()), numberFormatException);
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        return n;
    }

    private Double visitNumberDoubleExtendedJson() {
        Double d;
        this.verifyToken(JsonTokenType.COLON);
        String string = this.readStringFromExtendedJson();
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException(String.format("Exception converting value '%s' to type %s", string, Double.class.getName()), numberFormatException);
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        return d;
    }

    private Decimal128 visitNumberDecimalExtendedJson() {
        Decimal128 decimal128;
        this.verifyToken(JsonTokenType.COLON);
        String string = this.readStringFromExtendedJson();
        try {
            decimal128 = Decimal128.parse(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException(String.format("Exception converting value '%s' to type %s", string, Decimal128.class.getName()), numberFormatException);
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        return decimal128;
    }

    private BsonDbPointer visitDbPointerExtendedJson() {
        ObjectId objectId;
        String string;
        this.verifyToken(JsonTokenType.COLON);
        this.verifyToken(JsonTokenType.BEGIN_OBJECT);
        String string2 = this.readStringFromExtendedJson();
        if (string2.equals("$ref")) {
            this.verifyToken(JsonTokenType.COLON);
            string = this.readStringFromExtendedJson();
            this.verifyToken(JsonTokenType.COMMA);
            this.verifyString("$id");
            objectId = this.readDbPointerIdFromExtendedJson();
            this.verifyToken(JsonTokenType.END_OBJECT);
        } else if (string2.equals("$id")) {
            objectId = this.readDbPointerIdFromExtendedJson();
            this.verifyToken(JsonTokenType.COMMA);
            this.verifyString("$ref");
            this.verifyToken(JsonTokenType.COLON);
            string = this.readStringFromExtendedJson();
        } else {
            throw new JsonParseException("Expected $ref and $id fields in $dbPointer document but found " + string2);
        }
        this.verifyToken(JsonTokenType.END_OBJECT);
        return new BsonDbPointer(string, objectId);
    }

    private ObjectId readDbPointerIdFromExtendedJson() {
        this.verifyToken(JsonTokenType.COLON);
        this.verifyToken(JsonTokenType.BEGIN_OBJECT);
        this.verifyToken(JsonTokenType.STRING, "$oid");
        ObjectId objectId = this.visitObjectIdExtendedJson();
        return objectId;
    }

    @Override
    public BsonReaderMark getMark() {
        return new Mark();
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    private static byte[] decodeHex(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("A hex string must contain an even number of characters: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            int n = Character.digit(string.charAt(i), 16);
            int n2 = Character.digit(string.charAt(i + 1), 16);
            if (n == -1 || n2 == -1) {
                throw new IllegalArgumentException("A hex string can only contain the characters 0-9, A-F, a-f: " + string);
            }
            byArray[i / 2] = (byte)(n * 16 + n2);
        }
        return byArray;
    }

    private String readStringKeyFromExtendedJson() {
        JsonToken jsonToken = this.popToken();
        if (jsonToken.getType() != JsonTokenType.STRING && jsonToken.getType() != JsonTokenType.UNQUOTED_STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", jsonToken.getValue());
        }
        return jsonToken.getValue(String.class);
    }

    protected class Context
    extends AbstractBsonReader.Context {
        protected Context(AbstractBsonReader.Context context, BsonContextType bsonContextType) {
            super(JsonReader.this, context, bsonContextType);
        }

        @Override
        protected Context getParentContext() {
            return (Context)super.getParentContext();
        }

        @Override
        protected BsonContextType getContextType() {
            return super.getContextType();
        }
    }

    protected class Mark
    extends AbstractBsonReader.Mark {
        private final JsonToken pushedToken;
        private final Object currentValue;
        private final int markPos;

        protected Mark() {
            super(JsonReader.this);
            this.pushedToken = JsonReader.this.pushedToken;
            this.currentValue = JsonReader.this.currentValue;
            this.markPos = JsonReader.this.scanner.mark();
        }

        @Override
        public void reset() {
            super.reset();
            JsonReader.this.pushedToken = this.pushedToken;
            JsonReader.this.currentValue = this.currentValue;
            JsonReader.this.scanner.reset(this.markPos);
            JsonReader.this.setContext(new Context(this.getParentContext(), this.getContextType()));
        }

        public void discard() {
            JsonReader.this.scanner.discard(this.markPos);
        }
    }
}

