/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.io.Reader;
import org.bson.BsonRegularExpression;
import org.bson.json.JsonBuffer;
import org.bson.json.JsonParseException;
import org.bson.json.JsonStreamBuffer;
import org.bson.json.JsonStringBuffer;
import org.bson.json.JsonToken;
import org.bson.json.JsonTokenType;

class JsonScanner {
    private final JsonBuffer buffer;

    JsonScanner(JsonBuffer jsonBuffer) {
        this.buffer = jsonBuffer;
    }

    JsonScanner(String string) {
        this(new JsonStringBuffer(string));
    }

    JsonScanner(Reader reader) {
        this(new JsonStreamBuffer(reader));
    }

    public void reset(int n) {
        this.buffer.reset(n);
    }

    public int mark() {
        return this.buffer.mark();
    }

    public void discard(int n) {
        this.buffer.discard(n);
    }

    public JsonToken nextToken() {
        int n = this.buffer.read();
        while (n != -1 && Character.isWhitespace(n)) {
            n = this.buffer.read();
        }
        if (n == -1) {
            return new JsonToken(JsonTokenType.END_OF_FILE, "<eof>");
        }
        switch (n) {
            case 123: {
                return new JsonToken(JsonTokenType.BEGIN_OBJECT, "{");
            }
            case 125: {
                return new JsonToken(JsonTokenType.END_OBJECT, "}");
            }
            case 91: {
                return new JsonToken(JsonTokenType.BEGIN_ARRAY, "[");
            }
            case 93: {
                return new JsonToken(JsonTokenType.END_ARRAY, "]");
            }
            case 40: {
                return new JsonToken(JsonTokenType.LEFT_PAREN, "(");
            }
            case 41: {
                return new JsonToken(JsonTokenType.RIGHT_PAREN, ")");
            }
            case 58: {
                return new JsonToken(JsonTokenType.COLON, ":");
            }
            case 44: {
                return new JsonToken(JsonTokenType.COMMA, ",");
            }
            case 34: 
            case 39: {
                return this.scanString((char)n);
            }
            case 47: {
                return this.scanRegularExpression();
            }
        }
        if (n == 45 || Character.isDigit(n)) {
            return this.scanNumber((char)n);
        }
        if (n == 36 || n == 95 || Character.isLetter(n)) {
            return this.scanUnquotedString((char)n);
        }
        int n2 = this.buffer.getPosition();
        this.buffer.unread(n);
        throw new JsonParseException("Invalid JSON input. Position: %d. Character: '%c'.", n2, n);
    }

    private JsonToken scanRegularExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        RegularExpressionState regularExpressionState = RegularExpressionState.IN_PATTERN;
        while (true) {
            int n = this.buffer.read();
            block0 : switch (regularExpressionState) {
                case IN_PATTERN: {
                    switch (n) {
                        case -1: {
                            regularExpressionState = RegularExpressionState.INVALID;
                            break block0;
                        }
                        case 47: {
                            regularExpressionState = RegularExpressionState.IN_OPTIONS;
                            break block0;
                        }
                        case 92: {
                            regularExpressionState = RegularExpressionState.IN_ESCAPE_SEQUENCE;
                            break block0;
                        }
                    }
                    regularExpressionState = RegularExpressionState.IN_PATTERN;
                    break;
                }
                case IN_ESCAPE_SEQUENCE: {
                    regularExpressionState = RegularExpressionState.IN_PATTERN;
                    break;
                }
                case IN_OPTIONS: {
                    switch (n) {
                        case 105: 
                        case 109: 
                        case 115: 
                        case 120: {
                            regularExpressionState = RegularExpressionState.IN_OPTIONS;
                            break block0;
                        }
                        case -1: 
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            regularExpressionState = RegularExpressionState.DONE;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(n)) {
                        regularExpressionState = RegularExpressionState.DONE;
                        break;
                    }
                    regularExpressionState = RegularExpressionState.INVALID;
                    break;
                }
            }
            switch (regularExpressionState) {
                case DONE: {
                    this.buffer.unread(n);
                    BsonRegularExpression bsonRegularExpression = new BsonRegularExpression(stringBuilder.toString(), stringBuilder2.toString());
                    return new JsonToken(JsonTokenType.REGULAR_EXPRESSION, bsonRegularExpression);
                }
                case INVALID: {
                    throw new JsonParseException("Invalid JSON regular expression. Position: %d.", this.buffer.getPosition());
                }
            }
            if (regularExpressionState == RegularExpressionState.IN_OPTIONS) {
                if (n == 47) continue;
                stringBuilder2.append((char)n);
                continue;
            }
            stringBuilder.append((char)n);
        }
    }

    private JsonToken scanUnquotedString(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        int n = this.buffer.read();
        while (n == 36 || n == 95 || Character.isLetterOrDigit(n)) {
            stringBuilder.append((char)n);
            n = this.buffer.read();
        }
        this.buffer.unread(n);
        String string = stringBuilder.toString();
        return new JsonToken(JsonTokenType.UNQUOTED_STRING, string);
    }

    private JsonToken scanNumber(char n) {
        NumberState numberState;
        int n2 = n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        switch (n2) {
            case 45: {
                numberState = NumberState.SAW_LEADING_MINUS;
                break;
            }
            case 48: {
                numberState = NumberState.SAW_LEADING_ZERO;
                break;
            }
            default: {
                numberState = NumberState.SAW_INTEGER_DIGITS;
            }
        }
        JsonTokenType jsonTokenType = JsonTokenType.INT64;
        while (true) {
            n2 = this.buffer.read();
            block4 : switch (numberState) {
                case SAW_LEADING_MINUS: {
                    switch (n2) {
                        case 48: {
                            numberState = NumberState.SAW_LEADING_ZERO;
                            break block4;
                        }
                        case 73: {
                            numberState = NumberState.SAW_MINUS_I;
                            break block4;
                        }
                    }
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_INTEGER_DIGITS;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_LEADING_ZERO: {
                    switch (n2) {
                        case 46: {
                            numberState = NumberState.SAW_DECIMAL_POINT;
                            break block4;
                        }
                        case 69: 
                        case 101: {
                            numberState = NumberState.SAW_EXPONENT_LETTER;
                            break block4;
                        }
                        case -1: 
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            numberState = NumberState.DONE;
                            break block4;
                        }
                    }
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_INTEGER_DIGITS;
                        break;
                    }
                    if (Character.isWhitespace(n2)) {
                        numberState = NumberState.DONE;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_INTEGER_DIGITS: {
                    switch (n2) {
                        case 46: {
                            numberState = NumberState.SAW_DECIMAL_POINT;
                            break block4;
                        }
                        case 69: 
                        case 101: {
                            numberState = NumberState.SAW_EXPONENT_LETTER;
                            break block4;
                        }
                        case -1: 
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            numberState = NumberState.DONE;
                            break block4;
                        }
                    }
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_INTEGER_DIGITS;
                        break;
                    }
                    if (Character.isWhitespace(n2)) {
                        numberState = NumberState.DONE;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_DECIMAL_POINT: {
                    jsonTokenType = JsonTokenType.DOUBLE;
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_FRACTION_DIGITS;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_FRACTION_DIGITS: {
                    switch (n2) {
                        case 69: 
                        case 101: {
                            numberState = NumberState.SAW_EXPONENT_LETTER;
                            break block4;
                        }
                        case -1: 
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            numberState = NumberState.DONE;
                            break block4;
                        }
                    }
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_FRACTION_DIGITS;
                        break;
                    }
                    if (Character.isWhitespace(n2)) {
                        numberState = NumberState.DONE;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_EXPONENT_LETTER: {
                    jsonTokenType = JsonTokenType.DOUBLE;
                    switch (n2) {
                        case 43: 
                        case 45: {
                            numberState = NumberState.SAW_EXPONENT_SIGN;
                            break block4;
                        }
                    }
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_EXPONENT_DIGITS;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_EXPONENT_SIGN: {
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_EXPONENT_DIGITS;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_EXPONENT_DIGITS: {
                    switch (n2) {
                        case 41: 
                        case 44: 
                        case 93: 
                        case 125: {
                            numberState = NumberState.DONE;
                            break block4;
                        }
                    }
                    if (Character.isDigit(n2)) {
                        numberState = NumberState.SAW_EXPONENT_DIGITS;
                        break;
                    }
                    if (Character.isWhitespace(n2)) {
                        numberState = NumberState.DONE;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
                case SAW_MINUS_I: {
                    boolean bl = true;
                    char[] cArray = new char[]{'n', 'f', 'i', 'n', 'i', 't', 'y'};
                    for (int i = 0; i < cArray.length; ++i) {
                        if (n2 != cArray[i]) {
                            bl = false;
                            break;
                        }
                        stringBuilder.append((char)n2);
                        n2 = this.buffer.read();
                    }
                    if (bl) {
                        jsonTokenType = JsonTokenType.DOUBLE;
                        switch (n2) {
                            case -1: 
                            case 41: 
                            case 44: 
                            case 93: 
                            case 125: {
                                numberState = NumberState.DONE;
                                break block4;
                            }
                        }
                        if (Character.isWhitespace(n2)) {
                            numberState = NumberState.DONE;
                            break;
                        }
                        numberState = NumberState.INVALID;
                        break;
                    }
                    numberState = NumberState.INVALID;
                    break;
                }
            }
            switch (numberState) {
                case INVALID: {
                    throw new JsonParseException("Invalid JSON number");
                }
                case DONE: {
                    this.buffer.unread(n2);
                    String string = stringBuilder.toString();
                    if (jsonTokenType == JsonTokenType.DOUBLE) {
                        return new JsonToken(JsonTokenType.DOUBLE, Double.parseDouble(string));
                    }
                    long l = Long.parseLong(string);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        return new JsonToken(JsonTokenType.INT64, l);
                    }
                    return new JsonToken(JsonTokenType.INT32, (int)l);
                }
            }
            stringBuilder.append((char)n2);
        }
    }

    private JsonToken scanString(char c) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        block12: do {
            if ((n = this.buffer.read()) == 92) {
                n = this.buffer.read();
                switch (n) {
                    case 39: {
                        stringBuilder.append('\'');
                        continue block12;
                    }
                    case 34: {
                        stringBuilder.append('\"');
                        continue block12;
                    }
                    case 92: {
                        stringBuilder.append('\\');
                        continue block12;
                    }
                    case 47: {
                        stringBuilder.append('/');
                        continue block12;
                    }
                    case 98: {
                        stringBuilder.append('\b');
                        continue block12;
                    }
                    case 102: {
                        stringBuilder.append('\f');
                        continue block12;
                    }
                    case 110: {
                        stringBuilder.append('\n');
                        continue block12;
                    }
                    case 114: {
                        stringBuilder.append('\r');
                        continue block12;
                    }
                    case 116: {
                        stringBuilder.append('\t');
                        continue block12;
                    }
                    case 117: {
                        int n2 = this.buffer.read();
                        int n3 = this.buffer.read();
                        int n4 = this.buffer.read();
                        int n5 = this.buffer.read();
                        if (n5 == -1) continue block12;
                        String string = new String(new char[]{(char)n2, (char)n3, (char)n4, (char)n5});
                        stringBuilder.append((char)Integer.parseInt(string, 16));
                        continue block12;
                    }
                    default: {
                        throw new JsonParseException("Invalid escape sequence in JSON string '\\%c'.", n);
                    }
                }
            }
            if (n == c) {
                return new JsonToken(JsonTokenType.STRING, stringBuilder.toString());
            }
            if (n == -1) continue;
            stringBuilder.append((char)n);
        } while (n != -1);
        throw new JsonParseException("End of file in JSON string.");
    }

    private static enum RegularExpressionState {
        IN_PATTERN,
        IN_ESCAPE_SEQUENCE,
        IN_OPTIONS,
        DONE,
        INVALID;

    }

    private static enum NumberState {
        SAW_LEADING_MINUS,
        SAW_LEADING_ZERO,
        SAW_INTEGER_DIGITS,
        SAW_DECIMAL_POINT,
        SAW_FRACTION_DIGITS,
        SAW_EXPONENT_LETTER,
        SAW_EXPONENT_SIGN,
        SAW_EXPONENT_DIGITS,
        SAW_MINUS_I,
        DONE,
        INVALID;

    }
}

