/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.bson.json.JsonBuffer;
import org.bson.json.JsonParseException;

class JsonStreamBuffer
implements JsonBuffer {
    private final Reader reader;
    private final List<Integer> markedPositions = new ArrayList<Integer>();
    private final int initialBufferSize;
    private int position;
    private int lastChar;
    private boolean reuseLastChar;
    private boolean eof;
    private char[] buffer;
    private int bufferStartPos;
    private int bufferCount;

    JsonStreamBuffer(Reader reader) {
        this(reader, 16);
    }

    JsonStreamBuffer(Reader reader, int n) {
        this.initialBufferSize = n;
        this.reader = reader;
        this.resetBuffer();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int read() {
        if (this.eof) {
            throw new JsonParseException("Trying to read past EOF.");
        }
        if (this.reuseLastChar) {
            this.reuseLastChar = false;
            int n = this.lastChar;
            this.lastChar = -1;
            ++this.position;
            return n;
        }
        if (this.position - this.bufferStartPos < this.bufferCount) {
            int n;
            this.lastChar = n = this.buffer[this.position - this.bufferStartPos];
            ++this.position;
            return n;
        }
        if (this.markedPositions.isEmpty()) {
            this.resetBuffer();
        }
        try {
            int n = this.reader.read();
            if (n != -1) {
                this.lastChar = n;
                this.addToBuffer((char)n);
            }
            ++this.position;
            if (n == -1) {
                this.eof = true;
            }
            return n;
        }
        catch (IOException iOException) {
            throw new JsonParseException(iOException);
        }
    }

    private void resetBuffer() {
        this.bufferStartPos = -1;
        this.bufferCount = 0;
        this.buffer = new char[this.initialBufferSize];
    }

    @Override
    public void unread(int n) {
        this.eof = false;
        if (n != -1 && this.lastChar == n) {
            this.reuseLastChar = true;
            --this.position;
        }
    }

    @Override
    public int mark() {
        if (this.bufferCount == 0) {
            this.bufferStartPos = this.position;
        }
        if (!this.markedPositions.contains(this.position)) {
            this.markedPositions.add(this.position);
        }
        return this.position;
    }

    @Override
    public void reset(int n) {
        if (n > this.position) {
            throw new IllegalStateException("mark cannot reset ahead of position, only back");
        }
        int n2 = this.markedPositions.indexOf(n);
        if (n2 == -1) {
            throw new IllegalArgumentException("mark invalidated");
        }
        if (n != this.position) {
            this.reuseLastChar = false;
        }
        this.markedPositions.subList(n2, this.markedPositions.size()).clear();
        this.position = n;
    }

    @Override
    public void discard(int n) {
        int n2 = this.markedPositions.indexOf(n);
        if (n2 == -1) {
            return;
        }
        this.markedPositions.subList(n2, this.markedPositions.size()).clear();
    }

    private void addToBuffer(char c) {
        if (!this.markedPositions.isEmpty()) {
            if (this.bufferCount == this.buffer.length) {
                char[] cArray = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, cArray, 0, this.bufferCount);
                this.buffer = cArray;
            }
            this.buffer[this.bufferCount] = c;
            ++this.bufferCount;
        }
    }
}

