/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.io.Writer;
import org.bson.AbstractBsonWriter;
import org.bson.BsonBinary;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.json.StrictCharacterStreamJsonWriter;
import org.bson.json.StrictCharacterStreamJsonWriterSettings;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class JsonWriter
extends AbstractBsonWriter {
    private final JsonWriterSettings settings;
    private final StrictCharacterStreamJsonWriter strictJsonWriter;

    public JsonWriter(Writer writer) {
        this(writer, JsonWriterSettings.builder().build());
    }

    public JsonWriter(Writer writer, JsonWriterSettings jsonWriterSettings) {
        super(jsonWriterSettings);
        this.settings = jsonWriterSettings;
        this.setContext(new Context(null, BsonContextType.TOP_LEVEL));
        this.strictJsonWriter = new StrictCharacterStreamJsonWriter(writer, StrictCharacterStreamJsonWriterSettings.builder().indent(jsonWriterSettings.isIndent()).newLineCharacters(jsonWriterSettings.getNewLineCharacters()).indentCharacters(jsonWriterSettings.getIndentCharacters()).maxLength(jsonWriterSettings.getMaxLength()).build());
    }

    public Writer getWriter() {
        return this.strictJsonWriter.getWriter();
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    @Override
    protected void doWriteName(String string) {
        this.strictJsonWriter.writeName(string);
    }

    @Override
    protected void doWriteStartDocument() {
        this.strictJsonWriter.writeStartObject();
        BsonContextType bsonContextType = this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
        this.setContext(new Context(this.getContext(), bsonContextType));
    }

    @Override
    protected void doWriteEndDocument() {
        this.strictJsonWriter.writeEndObject();
        if (this.getContext().getContextType() == BsonContextType.SCOPE_DOCUMENT) {
            this.setContext(this.getContext().getParentContext());
            this.writeEndDocument();
        } else {
            this.setContext(this.getContext().getParentContext());
        }
    }

    @Override
    protected void doWriteStartArray() {
        this.strictJsonWriter.writeStartArray();
        this.setContext(new Context(this.getContext(), BsonContextType.ARRAY));
    }

    @Override
    protected void doWriteEndArray() {
        this.strictJsonWriter.writeEndArray();
        this.setContext(this.getContext().getParentContext());
    }

    @Override
    protected void doWriteBinaryData(BsonBinary bsonBinary) {
        this.settings.getBinaryConverter().convert(bsonBinary, this.strictJsonWriter);
    }

    @Override
    public void doWriteBoolean(boolean bl) {
        this.settings.getBooleanConverter().convert(bl, this.strictJsonWriter);
    }

    @Override
    protected void doWriteDateTime(long l) {
        this.settings.getDateTimeConverter().convert(l, this.strictJsonWriter);
    }

    @Override
    protected void doWriteDBPointer(BsonDbPointer bsonDbPointer) {
        if (this.settings.getOutputMode() == JsonMode.EXTENDED) {
            this.strictJsonWriter.writeStartObject();
            this.strictJsonWriter.writeStartObject("$dbPointer");
            this.strictJsonWriter.writeString("$ref", bsonDbPointer.getNamespace());
            this.strictJsonWriter.writeName("$id");
            this.doWriteObjectId(bsonDbPointer.getId());
            this.strictJsonWriter.writeEndObject();
            this.strictJsonWriter.writeEndObject();
        } else {
            this.strictJsonWriter.writeStartObject();
            this.strictJsonWriter.writeString("$ref", bsonDbPointer.getNamespace());
            this.strictJsonWriter.writeName("$id");
            this.doWriteObjectId(bsonDbPointer.getId());
            this.strictJsonWriter.writeEndObject();
        }
    }

    @Override
    protected void doWriteDouble(double d) {
        this.settings.getDoubleConverter().convert(d, this.strictJsonWriter);
    }

    @Override
    protected void doWriteInt32(int n) {
        this.settings.getInt32Converter().convert(n, this.strictJsonWriter);
    }

    @Override
    protected void doWriteInt64(long l) {
        this.settings.getInt64Converter().convert(l, this.strictJsonWriter);
    }

    @Override
    protected void doWriteDecimal128(Decimal128 decimal128) {
        this.settings.getDecimal128Converter().convert(decimal128, this.strictJsonWriter);
    }

    @Override
    protected void doWriteJavaScript(String string) {
        this.settings.getJavaScriptConverter().convert(string, this.strictJsonWriter);
    }

    @Override
    protected void doWriteJavaScriptWithScope(String string) {
        this.writeStartDocument();
        this.writeString("$code", string);
        this.writeName("$scope");
    }

    @Override
    protected void doWriteMaxKey() {
        this.settings.getMaxKeyConverter().convert(null, this.strictJsonWriter);
    }

    @Override
    protected void doWriteMinKey() {
        this.settings.getMinKeyConverter().convert(null, this.strictJsonWriter);
    }

    @Override
    public void doWriteNull() {
        this.settings.getNullConverter().convert(null, this.strictJsonWriter);
    }

    @Override
    public void doWriteObjectId(ObjectId objectId) {
        this.settings.getObjectIdConverter().convert(objectId, this.strictJsonWriter);
    }

    @Override
    public void doWriteRegularExpression(BsonRegularExpression bsonRegularExpression) {
        this.settings.getRegularExpressionConverter().convert(bsonRegularExpression, this.strictJsonWriter);
    }

    @Override
    public void doWriteString(String string) {
        this.settings.getStringConverter().convert(string, this.strictJsonWriter);
    }

    @Override
    public void doWriteSymbol(String string) {
        this.settings.getSymbolConverter().convert(string, this.strictJsonWriter);
    }

    @Override
    public void doWriteTimestamp(BsonTimestamp bsonTimestamp) {
        this.settings.getTimestampConverter().convert(bsonTimestamp, this.strictJsonWriter);
    }

    @Override
    public void doWriteUndefined() {
        this.settings.getUndefinedConverter().convert(null, this.strictJsonWriter);
    }

    @Override
    public void flush() {
        this.strictJsonWriter.flush();
    }

    public boolean isTruncated() {
        return this.strictJsonWriter.isTruncated();
    }

    @Override
    protected boolean abortPipe() {
        return this.strictJsonWriter.isTruncated();
    }

    public class Context
    extends AbstractBsonWriter.Context {
        public Context(Context context, BsonContextType bsonContextType) {
            super(JsonWriter.this, context, bsonContextType);
        }

        @Override
        public Context getParentContext() {
            return (Context)super.getParentContext();
        }
    }
}

