/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.bson.json.Converter;
import org.bson.json.StrictJsonWriter;

class ShellDateTimeConverter
implements Converter<Long> {
    ShellDateTimeConverter() {
    }

    @Override
    public void convert(Long l, StrictJsonWriter strictJsonWriter) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (l >= -59014396800000L && l <= 253399536000000L) {
            strictJsonWriter.writeRaw(String.format("ISODate(\"%s\")", simpleDateFormat.format(new Date(l))));
        } else {
            strictJsonWriter.writeRaw(String.format("new Date(%d)", l));
        }
    }
}

