/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.io.IOException;
import java.io.Writer;
import org.bson.BSONException;
import org.bson.BsonInvalidOperationException;
import org.bson.assertions.Assertions;
import org.bson.json.StrictCharacterStreamJsonWriterSettings;
import org.bson.json.StrictJsonWriter;

public final class StrictCharacterStreamJsonWriter
implements StrictJsonWriter {
    private final Writer writer;
    private final StrictCharacterStreamJsonWriterSettings settings;
    private StrictJsonContext context = new StrictJsonContext(null, JsonContextType.TOP_LEVEL, "");
    private State state = State.INITIAL;
    private int curLength;
    private boolean isTruncated;

    public StrictCharacterStreamJsonWriter(Writer writer, StrictCharacterStreamJsonWriterSettings strictCharacterStreamJsonWriterSettings) {
        this.writer = writer;
        this.settings = strictCharacterStreamJsonWriterSettings;
    }

    public int getCurrentLength() {
        return this.curLength;
    }

    @Override
    public void writeStartObject(String string) {
        this.writeName(string);
        this.writeStartObject();
    }

    @Override
    public void writeStartArray(String string) {
        this.writeName(string);
        this.writeStartArray();
    }

    @Override
    public void writeBoolean(String string, boolean bl) {
        Assertions.notNull("name", string);
        this.writeName(string);
        this.writeBoolean(bl);
    }

    @Override
    public void writeNumber(String string, String string2) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", string2);
        this.writeName(string);
        this.writeNumber(string2);
    }

    @Override
    public void writeString(String string, String string2) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", string2);
        this.writeName(string);
        this.writeString(string2);
    }

    @Override
    public void writeRaw(String string, String string2) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", string2);
        this.writeName(string);
        this.writeRaw(string2);
    }

    @Override
    public void writeNull(String string) {
        this.writeName(string);
        this.writeNull();
    }

    @Override
    public void writeName(String string) {
        Assertions.notNull("name", string);
        this.checkState(State.NAME);
        if (this.context.hasElements) {
            this.write(",");
        }
        if (this.settings.isIndent()) {
            this.write(this.settings.getNewLineCharacters());
            this.write(this.context.indentation);
        } else if (this.context.hasElements) {
            this.write(" ");
        }
        this.writeStringHelper(string);
        this.write(": ");
        this.state = State.VALUE;
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.checkState(State.VALUE);
        this.preWriteValue();
        this.write(bl ? "true" : "false");
        this.setNextState();
    }

    @Override
    public void writeNumber(String string) {
        Assertions.notNull("value", string);
        this.checkState(State.VALUE);
        this.preWriteValue();
        this.write(string);
        this.setNextState();
    }

    @Override
    public void writeString(String string) {
        Assertions.notNull("value", string);
        this.checkState(State.VALUE);
        this.preWriteValue();
        this.writeStringHelper(string);
        this.setNextState();
    }

    @Override
    public void writeRaw(String string) {
        Assertions.notNull("value", string);
        this.checkState(State.VALUE);
        this.preWriteValue();
        this.write(string);
        this.setNextState();
    }

    @Override
    public void writeNull() {
        this.checkState(State.VALUE);
        this.preWriteValue();
        this.write("null");
        this.setNextState();
    }

    @Override
    public void writeStartObject() {
        if (this.state != State.INITIAL && this.state != State.VALUE) {
            throw new BsonInvalidOperationException("Invalid state " + (Object)((Object)this.state));
        }
        this.preWriteValue();
        this.write("{");
        this.context = new StrictJsonContext(this.context, JsonContextType.DOCUMENT, this.settings.getIndentCharacters());
        this.state = State.NAME;
    }

    @Override
    public void writeStartArray() {
        this.preWriteValue();
        this.write("[");
        this.context = new StrictJsonContext(this.context, JsonContextType.ARRAY, this.settings.getIndentCharacters());
        this.state = State.VALUE;
    }

    @Override
    public void writeEndObject() {
        this.checkState(State.NAME);
        if (this.settings.isIndent() && this.context.hasElements) {
            this.write(this.settings.getNewLineCharacters());
            this.write(this.context.parentContext.indentation);
        }
        this.write("}");
        this.context = this.context.parentContext;
        if (this.context.contextType == JsonContextType.TOP_LEVEL) {
            this.state = State.DONE;
        } else {
            this.setNextState();
        }
    }

    @Override
    public void writeEndArray() {
        this.checkState(State.VALUE);
        if (this.context.contextType != JsonContextType.ARRAY) {
            throw new BsonInvalidOperationException("Can't end an array if not in an array");
        }
        if (this.settings.isIndent() && this.context.hasElements) {
            this.write(this.settings.getNewLineCharacters());
            this.write(this.context.parentContext.indentation);
        }
        this.write("]");
        this.context = this.context.parentContext;
        if (this.context.contextType == JsonContextType.TOP_LEVEL) {
            this.state = State.DONE;
        } else {
            this.setNextState();
        }
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.throwBSONException(iOException);
        }
    }

    Writer getWriter() {
        return this.writer;
    }

    private void preWriteValue() {
        if (this.context.contextType == JsonContextType.ARRAY) {
            if (this.context.hasElements) {
                this.write(",");
            }
            if (this.settings.isIndent()) {
                this.write(this.settings.getNewLineCharacters());
                this.write(this.context.indentation);
            } else if (this.context.hasElements) {
                this.write(" ");
            }
        }
        this.context.hasElements = true;
    }

    private void setNextState() {
        this.state = this.context.contextType == JsonContextType.ARRAY ? State.VALUE : State.NAME;
    }

    private void writeStringHelper(String string) {
        this.write('\"');
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    this.write("\\\"");
                    continue block12;
                }
                case '\\': {
                    this.write("\\\\");
                    continue block12;
                }
                case '\b': {
                    this.write("\\b");
                    continue block12;
                }
                case '\f': {
                    this.write("\\f");
                    continue block12;
                }
                case '\n': {
                    this.write("\\n");
                    continue block12;
                }
                case '\r': {
                    this.write("\\r");
                    continue block12;
                }
                case '\t': {
                    this.write("\\t");
                    continue block12;
                }
                default: {
                    switch (Character.getType(c)) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            this.write(c);
                            continue block12;
                        }
                    }
                    this.write("\\u");
                    this.write(Integer.toHexString((c & 0xF000) >> 12));
                    this.write(Integer.toHexString((c & 0xF00) >> 8));
                    this.write(Integer.toHexString((c & 0xF0) >> 4));
                    this.write(Integer.toHexString(c & 0xF));
                }
            }
        }
        this.write('\"');
    }

    private void write(String string) {
        try {
            if (this.settings.getMaxLength() == 0 || string.length() + this.curLength < this.settings.getMaxLength()) {
                this.writer.write(string);
                this.curLength += string.length();
            } else {
                this.writer.write(string.substring(0, this.settings.getMaxLength() - this.curLength));
                this.curLength = this.settings.getMaxLength();
                this.isTruncated = true;
            }
        }
        catch (IOException iOException) {
            this.throwBSONException(iOException);
        }
    }

    private void write(char c) {
        try {
            if (this.settings.getMaxLength() == 0 || this.curLength < this.settings.getMaxLength()) {
                this.writer.write(c);
                ++this.curLength;
            } else {
                this.isTruncated = true;
            }
        }
        catch (IOException iOException) {
            this.throwBSONException(iOException);
        }
    }

    private void checkState(State state) {
        if (this.state != state) {
            throw new BsonInvalidOperationException("Invalid state " + (Object)((Object)this.state));
        }
    }

    private void throwBSONException(IOException iOException) {
        throw new BSONException("Wrapping IOException", iOException);
    }

    private static class StrictJsonContext {
        private final StrictJsonContext parentContext;
        private final JsonContextType contextType;
        private final String indentation;
        private boolean hasElements;

        StrictJsonContext(StrictJsonContext strictJsonContext, JsonContextType jsonContextType, String string) {
            this.parentContext = strictJsonContext;
            this.contextType = jsonContextType;
            this.indentation = strictJsonContext == null ? string : strictJsonContext.indentation + string;
        }
    }

    private static enum JsonContextType {
        TOP_LEVEL,
        DOCUMENT,
        ARRAY;

    }

    private static enum State {
        INITIAL,
        NAME,
        VALUE,
        DONE;

    }
}

