/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import org.bson.assertions.Assertions;

public final class StrictCharacterStreamJsonWriterSettings {
    private final boolean indent;
    private final String newLineCharacters;
    private final String indentCharacters;
    private final int maxLength;

    public static Builder builder() {
        return new Builder();
    }

    private StrictCharacterStreamJsonWriterSettings(Builder builder) {
        this.indent = builder.indent;
        this.newLineCharacters = builder.newLineCharacters != null ? builder.newLineCharacters : System.getProperty("line.separator");
        this.indentCharacters = builder.indentCharacters;
        this.maxLength = builder.maxLength;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public String getNewLineCharacters() {
        return this.newLineCharacters;
    }

    public String getIndentCharacters() {
        return this.indentCharacters;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public static final class Builder {
        private boolean indent;
        private String newLineCharacters = System.getProperty("line.separator");
        private String indentCharacters = "  ";
        private int maxLength;

        public StrictCharacterStreamJsonWriterSettings build() {
            return new StrictCharacterStreamJsonWriterSettings(this);
        }

        public Builder indent(boolean bl) {
            this.indent = bl;
            return this;
        }

        public Builder newLineCharacters(String string) {
            Assertions.notNull("newLineCharacters", string);
            this.newLineCharacters = string;
            return this;
        }

        public Builder indentCharacters(String string) {
            Assertions.notNull("indentCharacters", string);
            this.indentCharacters = string;
            return this;
        }

        public Builder maxLength(int n) {
            this.maxLength = n;
            return this;
        }

        private Builder() {
        }
    }
}

