/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.util.BitSet;

final class UuidStringValidator {
    private static final BitSet HEX_CHARS = new BitSet(103);

    private static void validateFourHexChars(String string, int n) {
        if (!(HEX_CHARS.get(string.charAt(n)) && HEX_CHARS.get(string.charAt(n + 1)) && HEX_CHARS.get(string.charAt(n + 2)) && HEX_CHARS.get(string.charAt(n + 3)))) {
            throw new IllegalArgumentException(String.format("Expected four hexadecimal characters in UUID string \"%s\" starting at position %d", string, n));
        }
    }

    private static void validateDash(String string, int n) {
        if (string.charAt(n) != '-') {
            throw new IllegalArgumentException(String.format("Expected dash in UUID string \"%s\" at position %d", string, n));
        }
    }

    static void validate(String string) {
        if (string.length() != 36) {
            throw new IllegalArgumentException(String.format("UUID string \"%s\" must be 36 characters", string));
        }
        UuidStringValidator.validateFourHexChars(string, 0);
        UuidStringValidator.validateFourHexChars(string, 4);
        UuidStringValidator.validateDash(string, 8);
        UuidStringValidator.validateFourHexChars(string, 9);
        UuidStringValidator.validateDash(string, 13);
        UuidStringValidator.validateFourHexChars(string, 14);
        UuidStringValidator.validateDash(string, 18);
        UuidStringValidator.validateFourHexChars(string, 19);
        UuidStringValidator.validateDash(string, 23);
        UuidStringValidator.validateFourHexChars(string, 24);
        UuidStringValidator.validateFourHexChars(string, 28);
        UuidStringValidator.validateFourHexChars(string, 32);
    }

    private UuidStringValidator() {
    }

    static {
        HEX_CHARS.set(48, 58);
        HEX_CHARS.set(65, 71);
        HEX_CHARS.set(97, 103);
    }
}

