/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.util.Date;

public final class BSONTimestamp
implements Comparable<BSONTimestamp>,
Serializable {
    private static final long serialVersionUID = -3268482672267936464L;
    private final int inc;
    private final Date time;

    public BSONTimestamp() {
        this.inc = 0;
        this.time = null;
    }

    public BSONTimestamp(int n, int n2) {
        this.time = new Date((long)n * 1000L);
        this.inc = n2;
    }

    public int getTime() {
        if (this.time == null) {
            return 0;
        }
        return (int)(this.time.getTime() / 1000L);
    }

    public int getInc() {
        return this.inc;
    }

    public String toString() {
        return "TS time:" + this.time + " inc:" + this.inc;
    }

    @Override
    public int compareTo(BSONTimestamp bSONTimestamp) {
        if (this.getTime() != bSONTimestamp.getTime()) {
            return this.getTime() - bSONTimestamp.getTime();
        }
        return this.getInc() - bSONTimestamp.getInc();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.inc;
        n2 = n * n2 + this.getTime();
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BSONTimestamp) {
            BSONTimestamp bSONTimestamp = (BSONTimestamp)object;
            return this.getTime() == bSONTimestamp.getTime() && this.getInc() == bSONTimestamp.getInc();
        }
        return false;
    }
}

