/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.types.StringRangeSet;

public class BasicBSONList
extends ArrayList<Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    @Override
    public Object put(String string, Object object) {
        return this.put(this._getInt(string), object);
    }

    public Object put(int n, Object object) {
        while (n >= this.size()) {
            this.add(null);
        }
        this.set(n, object);
        return object;
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject bSONObject) {
        for (String string : bSONObject.keySet()) {
            this.put(string, bSONObject.get(string));
        }
    }

    @Override
    public Object get(String string) {
        int n = this._getInt(string);
        if (n < 0) {
            return null;
        }
        if (n >= this.size()) {
            return null;
        }
        return this.get(n);
    }

    @Override
    public Object removeField(String string) {
        int n = this._getInt(string);
        if (n < 0) {
            return null;
        }
        if (n >= this.size()) {
            return null;
        }
        return this.remove(n);
    }

    @Override
    public boolean containsField(String string) {
        int n = this._getInt(string, false);
        if (n < 0) {
            return false;
        }
        return n >= 0 && n < this.size();
    }

    @Override
    public Set<String> keySet() {
        return new StringRangeSet(this.size());
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.keySet()) {
            hashMap.put(string, this.get(String.valueOf(string)));
        }
        return hashMap;
    }

    int _getInt(String string) {
        return this._getInt(string, true);
    }

    int _getInt(String string, boolean bl) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            if (bl) {
                throw new IllegalArgumentException("BasicBSONList can only work with numeric keys, not: [" + string + "]");
            }
            return -1;
        }
    }
}

