/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.util.Arrays;
import org.bson.BsonBinarySubType;

public class Binary
implements Serializable {
    private static final long serialVersionUID = 7902997490338209467L;
    private final byte type;
    private final byte[] data;

    public Binary(byte[] byArray) {
        this(BsonBinarySubType.BINARY, byArray);
    }

    public Binary(BsonBinarySubType bsonBinarySubType, byte[] byArray) {
        this(bsonBinarySubType.getValue(), byArray);
    }

    public Binary(byte by, byte[] byArray) {
        this.type = by;
        this.data = (byte[])byArray.clone();
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public int length() {
        return this.data.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Binary binary = (Binary)object;
        if (this.type != binary.type) {
            return false;
        }
        return Arrays.equals(this.data, binary.data);
    }

    public int hashCode() {
        int n = this.type;
        n = 31 * n + Arrays.hashCode(this.data);
        return n;
    }
}

