/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Decimal128
extends Number
implements Comparable<Decimal128> {
    private static final long serialVersionUID = 4570973266503637887L;
    private static final long INFINITY_MASK = 0x7800000000000000L;
    private static final long NaN_MASK = 0x7C00000000000000L;
    private static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    private static final int MIN_EXPONENT = -6176;
    private static final int MAX_EXPONENT = 6111;
    private static final int EXPONENT_OFFSET = 6176;
    private static final int MAX_BIT_LENGTH = 113;
    private static final BigInteger BIG_INT_TEN = new BigInteger("10");
    private static final BigInteger BIG_INT_ONE = new BigInteger("1");
    private static final BigInteger BIG_INT_ZERO = new BigInteger("0");
    private static final Set<String> NaN_STRINGS = new HashSet<String>(Collections.singletonList("nan"));
    private static final Set<String> NEGATIVE_NaN_STRINGS = new HashSet<String>(Collections.singletonList("-nan"));
    private static final Set<String> POSITIVE_INFINITY_STRINGS = new HashSet<String>(Arrays.asList("inf", "+inf", "infinity", "+infinity"));
    private static final Set<String> NEGATIVE_INFINITY_STRINGS = new HashSet<String>(Arrays.asList("-inf", "-infinity"));
    public static final Decimal128 POSITIVE_INFINITY = Decimal128.fromIEEE754BIDEncoding(0x7800000000000000L, 0L);
    public static final Decimal128 NEGATIVE_INFINITY = Decimal128.fromIEEE754BIDEncoding(-576460752303423488L, 0L);
    public static final Decimal128 NEGATIVE_NaN = Decimal128.fromIEEE754BIDEncoding(-288230376151711744L, 0L);
    public static final Decimal128 NaN = Decimal128.fromIEEE754BIDEncoding(0x7C00000000000000L, 0L);
    public static final Decimal128 POSITIVE_ZERO = Decimal128.fromIEEE754BIDEncoding(0x3040000000000000L, 0L);
    public static final Decimal128 NEGATIVE_ZERO = Decimal128.fromIEEE754BIDEncoding(-5746593124524752896L, 0L);
    private final long high;
    private final long low;

    public static Decimal128 parse(String string) {
        String string2 = string.toLowerCase();
        if (NaN_STRINGS.contains(string2)) {
            return NaN;
        }
        if (NEGATIVE_NaN_STRINGS.contains(string2)) {
            return NEGATIVE_NaN;
        }
        if (POSITIVE_INFINITY_STRINGS.contains(string2)) {
            return POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY_STRINGS.contains(string2)) {
            return NEGATIVE_INFINITY;
        }
        return new Decimal128(new BigDecimal(string), string.charAt(0) == '-');
    }

    public static Decimal128 fromIEEE754BIDEncoding(long l, long l2) {
        return new Decimal128(l, l2);
    }

    public Decimal128(long l) {
        this(new BigDecimal(l, MathContext.DECIMAL128));
    }

    public Decimal128(BigDecimal bigDecimal) {
        this(bigDecimal, bigDecimal.signum() == -1);
    }

    private Decimal128(long l, long l2) {
        this.high = l;
        this.low = l2;
    }

    private Decimal128(BigDecimal bigDecimal, boolean bl) {
        int n;
        long l = 0L;
        long l2 = 0L;
        BigDecimal bigDecimal2 = this.clampAndRound(bigDecimal);
        long l3 = -bigDecimal2.scale();
        if (l3 < -6176L || l3 > 6111L) {
            throw new AssertionError((Object)("Exponent is out of range for Decimal128 encoding: " + l3));
        }
        if (bigDecimal2.unscaledValue().bitLength() > 113) {
            throw new AssertionError((Object)("Unscaled roundedValue is out of range for Decimal128 encoding:" + bigDecimal2.unscaledValue()));
        }
        BigInteger bigInteger = bigDecimal2.unscaledValue().abs();
        int n2 = bigInteger.bitLength();
        for (n = 0; n < Math.min(64, n2); ++n) {
            if (!bigInteger.testBit(n)) continue;
            l2 |= 1L << n;
        }
        for (n = 64; n < n2; ++n) {
            if (!bigInteger.testBit(n)) continue;
            l |= 1L << n - 64;
        }
        long l4 = l3 + 6176L;
        l |= l4 << 49;
        if (bigDecimal2.signum() == -1 || bl) {
            l |= Long.MIN_VALUE;
        }
        this.high = l;
        this.low = l2;
    }

    private BigDecimal clampAndRound(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (-bigDecimal.scale() > 6111) {
            int n = -bigDecimal.scale() - 6111;
            if (bigDecimal.unscaledValue().equals(BIG_INT_ZERO)) {
                bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue(), -6111);
            } else {
                if (n + bigDecimal.precision() > 34) {
                    throw new NumberFormatException("Exponent is out of range for Decimal128 encoding of " + bigDecimal);
                }
                BigInteger bigInteger = BIG_INT_TEN.pow(n);
                bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue().multiply(bigInteger), bigDecimal.scale() + n);
            }
        } else if (-bigDecimal.scale() < -6176) {
            int n = bigDecimal.scale() + -6176;
            int n2 = this.ensureExactRounding(bigDecimal, n);
            BigInteger bigInteger = n2 == 0 ? BIG_INT_ONE : BIG_INT_TEN.pow(n);
            bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue().divide(bigInteger), bigDecimal.scale() - n);
        } else {
            bigDecimal2 = bigDecimal.round(MathContext.DECIMAL128);
            int n = bigDecimal.precision() - bigDecimal2.precision();
            if (n > 0) {
                this.ensureExactRounding(bigDecimal, n);
            }
        }
        return bigDecimal2;
    }

    private int ensureExactRounding(BigDecimal bigDecimal, int n) {
        int n2;
        String string = bigDecimal.unscaledValue().abs().toString();
        for (int i = n2 = Math.max(0, string.length() - n); i < string.length(); ++i) {
            if (string.charAt(i) == '0') continue;
            throw new NumberFormatException("Conversion to Decimal128 would require inexact rounding of " + bigDecimal);
        }
        return n2;
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public BigDecimal bigDecimalValue() {
        if (this.isNaN()) {
            throw new ArithmeticException("NaN can not be converted to a BigDecimal");
        }
        if (this.isInfinite()) {
            throw new ArithmeticException("Infinity can not be converted to a BigDecimal");
        }
        BigDecimal bigDecimal = this.bigDecimalValueNoNegativeZeroCheck();
        if (this.isNegative() && bigDecimal.signum() == 0) {
            throw new ArithmeticException("Negative zero can not be converted to a BigDecimal");
        }
        return bigDecimal;
    }

    private boolean hasDifferentSign(BigDecimal bigDecimal) {
        return this.isNegative() && bigDecimal.signum() == 0;
    }

    private boolean isZero(BigDecimal bigDecimal) {
        return !this.isNaN() && !this.isInfinite() && bigDecimal.compareTo(BigDecimal.ZERO) == 0;
    }

    private BigDecimal bigDecimalValueNoNegativeZeroCheck() {
        int n = -this.getExponent();
        if (this.twoHighestCombinationBitsAreSet()) {
            return BigDecimal.valueOf(0L, n);
        }
        return new BigDecimal(new BigInteger(this.isNegative() ? -1 : 1, this.getBytes()), n);
    }

    private byte[] getBytes() {
        int n;
        byte[] byArray = new byte[15];
        long l = 255L;
        for (n = 14; n >= 7; --n) {
            byArray[n] = (byte)((this.low & l) >>> (14 - n << 3));
            l <<= 8;
        }
        l = 255L;
        for (n = 6; n >= 1; --n) {
            byArray[n] = (byte)((this.high & l) >>> (6 - n << 3));
            l <<= 8;
        }
        l = 0x1000000000000L;
        byArray[0] = (byte)((this.high & l) >>> 48);
        return byArray;
    }

    private int getExponent() {
        if (this.twoHighestCombinationBitsAreSet()) {
            return (int)((this.high & 0x1FFFE00000000000L) >>> 47) - 6176;
        }
        return (int)((this.high & 0x7FFF800000000000L) >>> 49) - 6176;
    }

    private boolean twoHighestCombinationBitsAreSet() {
        return (this.high & 0x6000000000000000L) == 0x6000000000000000L;
    }

    public boolean isNegative() {
        return (this.high & Long.MIN_VALUE) == Long.MIN_VALUE;
    }

    public boolean isInfinite() {
        return (this.high & 0x7800000000000000L) == 0x7800000000000000L;
    }

    public boolean isFinite() {
        return !this.isInfinite();
    }

    public boolean isNaN() {
        return (this.high & 0x7C00000000000000L) == 0x7C00000000000000L;
    }

    @Override
    public int compareTo(Decimal128 decimal128) {
        if (this.isNaN()) {
            return decimal128.isNaN() ? 0 : 1;
        }
        if (this.isInfinite()) {
            if (this.isNegative()) {
                if (decimal128.isInfinite() && decimal128.isNegative()) {
                    return 0;
                }
                return -1;
            }
            if (decimal128.isNaN()) {
                return -1;
            }
            if (decimal128.isInfinite() && !decimal128.isNegative()) {
                return 0;
            }
            return 1;
        }
        BigDecimal bigDecimal = this.bigDecimalValueNoNegativeZeroCheck();
        BigDecimal bigDecimal2 = decimal128.bigDecimalValueNoNegativeZeroCheck();
        if (this.isZero(bigDecimal) && decimal128.isZero(bigDecimal2)) {
            if (this.hasDifferentSign(bigDecimal)) {
                if (decimal128.hasDifferentSign(bigDecimal2)) {
                    return 0;
                }
                return -1;
            }
            if (decimal128.hasDifferentSign(bigDecimal2)) {
                return 1;
            }
        }
        if (decimal128.isNaN()) {
            return -1;
        }
        if (decimal128.isInfinite()) {
            if (decimal128.isNegative()) {
                return 1;
            }
            return -1;
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            if (this.isNegative()) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = this.bigDecimalValueNoNegativeZeroCheck();
        if (this.hasDifferentSign(bigDecimal)) {
            return -0.0;
        }
        return bigDecimal.doubleValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Decimal128 decimal128 = (Decimal128)object;
        if (this.high != decimal128.high) {
            return false;
        }
        return this.low == decimal128.low;
    }

    public int hashCode() {
        int n = (int)(this.low ^ this.low >>> 32);
        n = 31 * n + (int)(this.high ^ this.high >>> 32);
        return n;
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInfinite()) {
            if (this.isNegative()) {
                return "-Infinity";
            }
            return "Infinity";
        }
        return this.toStringWithBigDecimal();
    }

    private String toStringWithBigDecimal() {
        StringBuilder stringBuilder = new StringBuilder();
        BigDecimal bigDecimal = this.bigDecimalValueNoNegativeZeroCheck();
        String string = bigDecimal.unscaledValue().abs().toString();
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        int n = -bigDecimal.scale();
        int n2 = n + (string.length() - 1);
        if (n <= 0 && n2 >= -6) {
            if (n == 0) {
                stringBuilder.append(string);
            } else {
                int n3 = -n - string.length();
                if (n3 >= 0) {
                    stringBuilder.append('0');
                    stringBuilder.append('.');
                    for (int i = 0; i < n3; ++i) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string, 0, string.length());
                } else {
                    stringBuilder.append(string, 0, -n3);
                    stringBuilder.append('.');
                    stringBuilder.append(string, -n3, -n3 - n);
                }
            }
        } else {
            stringBuilder.append(string.charAt(0));
            if (string.length() > 1) {
                stringBuilder.append('.');
                stringBuilder.append(string, 1, string.length());
            }
            stringBuilder.append('E');
            if (n2 > 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }
}

