/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.assertions.Assertions;

public final class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int OBJECT_ID_LENGTH = 12;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final long RANDOM_VALUE;
    private static final AtomicInteger NEXT_COUNTER;
    private static final char[] HEX_CHARS;
    private final int timestamp;
    private final long nonce;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static ObjectId getSmallestWithDate(Date date) {
        return new ObjectId(ObjectId.dateToTimestampSeconds(date), 0L);
    }

    public static boolean isValid(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = string.length();
        if (n != 24) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public ObjectId() {
        this(new Date());
    }

    public ObjectId(Date date) {
        this(ObjectId.dateToTimestampSeconds(date), RANDOM_VALUE | (long)(NEXT_COUNTER.getAndIncrement() & 0xFFFFFF));
    }

    public ObjectId(Date date, int n) {
        this(ObjectId.dateToTimestampSeconds(date), ObjectId.getNonceFromUntrustedCounter(n));
    }

    public ObjectId(int n, int n2) {
        this(n, ObjectId.getNonceFromUntrustedCounter(n2));
    }

    private ObjectId(int n, long l) {
        this.timestamp = n;
        this.nonce = l;
    }

    private static long getNonceFromUntrustedCounter(int n) {
        if ((n & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        return RANDOM_VALUE | (long)n;
    }

    public ObjectId(String string) {
        this(ObjectId.parseHexString(string));
    }

    public ObjectId(byte[] byArray) {
        this(ByteBuffer.wrap(Assertions.isTrueArgument("bytes has length of 12", byArray, Assertions.notNull("bytes", byArray).length == 12)));
    }

    public ObjectId(ByteBuffer byteBuffer) {
        Assertions.notNull("buffer", byteBuffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", byteBuffer.remaining() >= 12);
        ByteOrder byteOrder = byteBuffer.order();
        try {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            this.timestamp = byteBuffer.getInt();
            this.nonce = byteBuffer.getLong();
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    public byte[] toByteArray() {
        return ByteBuffer.allocate(12).putInt(this.timestamp).putLong(this.nonce).array();
    }

    public void putToByteBuffer(ByteBuffer byteBuffer) {
        Assertions.notNull("buffer", byteBuffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", byteBuffer.remaining() >= 12);
        ByteOrder byteOrder = byteBuffer.order();
        try {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putInt(this.timestamp);
            byteBuffer.putLong(this.nonce);
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public Date getDate() {
        return new Date(((long)this.timestamp & 0xFFFFFFFFL) * 1000L);
    }

    public String toHexString() {
        char[] cArray = new char[24];
        int n = 0;
        for (byte by : this.toByteArray()) {
            cArray[n++] = HEX_CHARS[by >> 4 & 0xF];
            cArray[n++] = HEX_CHARS[by & 0xF];
        }
        return new String(cArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObjectId objectId = (ObjectId)object;
        if (this.timestamp != objectId.timestamp) {
            return false;
        }
        return this.nonce == objectId.nonce;
    }

    public int hashCode() {
        return 31 * this.timestamp + Long.hashCode(this.nonce);
    }

    @Override
    public int compareTo(ObjectId objectId) {
        int n = Integer.compareUnsigned(this.timestamp, objectId.timestamp);
        if (n != 0) {
            return n;
        }
        return Long.compareUnsigned(this.nonce, objectId.nonce);
    }

    public String toString() {
        return this.toHexString();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static byte[] parseHexString(String string) {
        Assertions.notNull("hexString", string);
        Assertions.isTrueArgument("hexString has 24 characters", string.length() == 24);
        byte[] byArray = new byte[12];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i << 1;
            char c = string.charAt(n);
            char c2 = string.charAt(n + 1);
            byArray[i] = (byte)((ObjectId.hexCharToInt(c) << 4) + ObjectId.hexCharToInt(c2));
        }
        return byArray;
    }

    private static int hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        throw new IllegalArgumentException("invalid hexadecimal character: [" + c + "]");
    }

    private static int dateToTimestampSeconds(Date date) {
        return (int)(date.getTime() / 1000L);
    }

    static {
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            SecureRandom secureRandom = new SecureRandom();
            RANDOM_VALUE = secureRandom.nextLong() & 0xFFFFFFFFFF000000L;
            NEXT_COUNTER = new AtomicInteger(secureRandom.nextInt());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        SerializationProxy(ObjectId objectId) {
            this.bytes = objectId.toByteArray();
        }

        private Object readResolve() {
            return new ObjectId(this.bytes);
        }
    }
}

