/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.bson.assertions.Assertions;

class StringRangeSet
implements Set<String> {
    private static final String[] STRINGS = new String[1024];
    private final int size;

    StringRangeSet(int n) {
        Assertions.isTrue("size >= 0", n >= 0);
        this.size = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        try {
            int n = Integer.parseInt((String)object);
            return n >= 0 && n < this.size();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int cur = 0;

            @Override
            public boolean hasNext() {
                return this.cur < StringRangeSet.this.size;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StringRangeSet.this.intToString(this.cur++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objectArray[i] = this.intToString(i);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        T[] TArray2 = TArray.length >= this.size() ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size);
        for (int i = 0; i < this.size(); ++i) {
            TArray2[i] = this.intToString(i);
        }
        if (TArray.length > this.size()) {
            TArray[this.size] = null;
        }
        return TArray2;
    }

    @Override
    public boolean add(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private String intToString(int n) {
        return n < STRINGS.length ? STRINGS[n] : Integer.toString(n);
    }

    static {
        for (int i = 0; i < STRINGS.length; ++i) {
            StringRangeSet.STRINGS[i] = String.valueOf(i);
        }
    }
}

