/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientBulkWriteException;
import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCluster;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.SynchronousContextProvider;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.Crypts;
import com.mongodb.client.internal.MongoClusterImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.SocketSettings;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.connection.ClientMetadataHelper;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.DefaultClusterFactory;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryHelper;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final MongoClientSettings settings;
    private final MongoDriverInformation mongoDriverInformation;
    private final MongoClusterImpl delegate;
    private final AtomicBoolean closed;

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        this(MongoClientImpl.createCluster(settings, mongoDriverInformation), mongoDriverInformation, settings, null);
    }

    public MongoClientImpl(Cluster cluster, MongoDriverInformation mongoDriverInformation, MongoClientSettings settings, @Nullable OperationExecutor operationExecutor) {
        this.settings = Assertions.notNull("settings", settings);
        this.mongoDriverInformation = mongoDriverInformation;
        AutoEncryptionSettings autoEncryptionSettings = settings.getAutoEncryptionSettings();
        if (settings.getContextProvider() != null && !(settings.getContextProvider() instanceof SynchronousContextProvider)) {
            throw new IllegalArgumentException("The contextProvider must be an instance of " + SynchronousContextProvider.class.getName() + " when using the synchronous driver");
        }
        this.delegate = new MongoClusterImpl(autoEncryptionSettings, cluster, CodecRegistries.withUuidRepresentation(settings.getCodecRegistry(), settings.getUuidRepresentation()), (SynchronousContextProvider)settings.getContextProvider(), autoEncryptionSettings == null ? null : Crypts.createCrypt(settings, autoEncryptionSettings), this, operationExecutor, settings.getReadConcern(), settings.getReadPreference(), settings.getRetryReads(), settings.getRetryWrites(), settings.getServerApi(), new ServerSessionPool(cluster, TimeoutSettings.create(settings), settings.getServerApi()), TimeoutSettings.create(settings), settings.getUuidRepresentation(), settings.getWriteConcern());
        this.closed = new AtomicBoolean();
        BsonDocument clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(settings.getApplicationName(), mongoDriverInformation);
        LOGGER.info(String.format("MongoClient with metadata %s created with settings %s", clientMetadataDocument.toJson(), settings));
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            Crypt crypt = this.delegate.getCrypt();
            if (crypt != null) {
                crypt.close();
            }
            this.delegate.getServerSessionPool().close();
            this.delegate.getCluster().close();
        }
    }

    @Override
    public ClusterDescription getClusterDescription() {
        return this.delegate.getCluster().getCurrentDescription();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.delegate.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.delegate.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.delegate.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        return this.delegate.getTimeout(timeUnit);
    }

    @Override
    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return this.delegate.withCodecRegistry(codecRegistry);
    }

    @Override
    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return this.delegate.withReadPreference(readPreference);
    }

    @Override
    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return this.delegate.withWriteConcern(writeConcern);
    }

    @Override
    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return this.delegate.withReadConcern(readConcern);
    }

    @Override
    public MongoCluster withTimeout(long timeout, TimeUnit timeUnit) {
        return this.delegate.withTimeout(timeout, timeUnit);
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public ClientSession startSession() {
        return this.delegate.startSession();
    }

    @Override
    public ClientSession startSession(ClientSessionOptions options) {
        return this.delegate.startSession(options);
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.delegate.listDatabaseNames();
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        return this.delegate.listDatabaseNames(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.delegate.listDatabases();
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.delegate.listDatabases(clientSession);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> resultClass) {
        return this.delegate.listDatabases(resultClass);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.listDatabases(clientSession, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.delegate.watch();
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.delegate.watch(resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.delegate.watch(pipeline);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.delegate.watch(clientSession);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.delegate.watch(clientSession, pipeline);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, pipeline, resultClass);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(clientWriteModels);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(clientWriteModels, options);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(clientSession, clientWriteModels);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(clientSession, clientWriteModels, options);
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        Assertions.notNull("settings", settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), InternalConnectionPoolSettings.builder().build(), TimeoutSettings.create(settings), MongoClientImpl.getStreamFactory(settings, false), TimeoutSettings.createHeartbeatSettings(settings), MongoClientImpl.getStreamFactory(settings, true), settings.getCredential(), settings.getLoggerSettings(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList(), settings.getServerApi(), settings.getDnsClient());
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, boolean isHeartbeat) {
        SocketSettings socketSettings = isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings();
        InetAddressResolver inetAddressResolver = ServerAddressHelper.getInetAddressResolver(settings);
        return StreamFactoryHelper.getSyncStreamFactory(settings, inetAddressResolver, socketSettings);
    }

    public Cluster getCluster() {
        return this.delegate.getCluster();
    }

    public ServerSessionPool getServerSessionPool() {
        return this.delegate.getServerSessionPool();
    }

    public OperationExecutor getOperationExecutor() {
        return this.delegate.getOperationExecutor();
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.delegate.getTimeoutSettings();
    }

    public MongoClientSettings getSettings() {
        return this.settings;
    }

    public MongoDriverInformation getMongoDriverInformation() {
        return this.mongoDriverInformation;
    }
}

