/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import com.mongodb.internal.connection.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.connection.SslHelper;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.connection.tlschannel.BufferAllocator;
import com.mongodb.internal.connection.tlschannel.ClientTlsChannel;
import com.mongodb.internal.connection.tlschannel.async.AsynchronousTlsChannel;
import com.mongodb.internal.connection.tlschannel.async.AsynchronousTlsChannelGroup;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class TlsChannelStreamFactoryFactory
implements StreamFactoryFactory {
    private static final Logger LOGGER = Loggers.getLogger("connection.tls");
    private final SelectorMonitor selectorMonitor;
    private final AsynchronousTlsChannelGroup group;
    private final PowerOfTwoBufferPool bufferPool = PowerOfTwoBufferPool.DEFAULT;
    private final InetAddressResolver inetAddressResolver;

    TlsChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver, @Nullable ExecutorService executorService) {
        this.inetAddressResolver = inetAddressResolver;
        this.group = new AsynchronousTlsChannelGroup(executorService);
        this.selectorMonitor = new SelectorMonitor();
        this.selectorMonitor.start();
    }

    public TlsChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver) {
        this(inetAddressResolver, null);
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        Assertions.assertTrue(sslSettings.isEnabled());
        return serverAddress -> new TlsChannelStream(serverAddress, this.inetAddressResolver, socketSettings, sslSettings, this.bufferPool, this.group, this.selectorMonitor);
    }

    @Override
    public void close() {
        this.selectorMonitor.close();
        this.group.shutdown();
    }

    private static class SelectorMonitor
    implements Closeable {
        private final Selector selector;
        private volatile boolean isClosed;
        private final ConcurrentLinkedDeque<Pair> pendingRegistrations = new ConcurrentLinkedDeque();

        SelectorMonitor() {
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                throw new MongoClientException("Exception opening Selector", e);
            }
        }

        void start() {
            Thread selectorThread = new Thread(() -> {
                try {
                    while (!this.isClosed) {
                        try {
                            this.selector.select();
                            for (SelectionKey selectionKey : this.selector.selectedKeys()) {
                                selectionKey.cancel();
                                Runnable runnable = (Runnable)selectionKey.attachment();
                                runnable.run();
                            }
                            Iterator<Pair> iter = this.pendingRegistrations.iterator();
                            while (iter.hasNext()) {
                                Pair pendingRegistration = iter.next();
                                pendingRegistration.socketChannel.register(this.selector, 8, pendingRegistration.attachment);
                                iter.remove();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warn("Exception in selector loop", e);
                        }
                    }
                }
                finally {
                    try {
                        this.selector.close();
                    }
                    catch (IOException iOException) {}
                }
            });
            selectorThread.setDaemon(true);
            selectorThread.start();
        }

        void register(SocketChannel channel, Runnable attachment) {
            this.pendingRegistrations.add(new Pair(channel, attachment));
            this.selector.wakeup();
        }

        @Override
        public void close() {
            this.isClosed = true;
            this.selector.wakeup();
        }

        private static final class Pair {
            private final SocketChannel socketChannel;
            private final Runnable attachment;

            private Pair(SocketChannel socketChannel, Runnable attachment) {
                this.socketChannel = socketChannel;
                this.attachment = attachment;
            }
        }
    }

    private static class TlsChannelStream
    extends AsynchronousChannelStream {
        private final AsynchronousTlsChannelGroup group;
        private final SelectorMonitor selectorMonitor;
        private final InetAddressResolver inetAddressResolver;
        private final SslSettings sslSettings;

        TlsChannelStream(ServerAddress serverAddress, InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings, PowerOfTwoBufferPool bufferProvider, AsynchronousTlsChannelGroup group, SelectorMonitor selectorMonitor) {
            super(serverAddress, settings, bufferProvider);
            this.inetAddressResolver = inetAddressResolver;
            this.sslSettings = sslSettings;
            this.group = group;
            this.selectorMonitor = selectorMonitor;
        }

        @Override
        public void openAsync(OperationContext operationContext, AsyncCompletionHandler<Void> handler) {
            Assertions.isTrue("unopened", this.getChannel() == null);
            try {
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
                socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                if (this.getSettings().getReceiveBufferSize() > 0) {
                    socketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.getSettings().getReceiveBufferSize());
                }
                if (this.getSettings().getSendBufferSize() > 0) {
                    socketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.getSettings().getSendBufferSize());
                }
                socketChannel.connect(ServerAddressHelper.getSocketAddresses(this.getServerAddress(), this.inetAddressResolver).get(0));
                this.selectorMonitor.register(socketChannel, () -> {
                    try {
                        if (!socketChannel.finishConnect()) {
                            throw new MongoSocketOpenException("Failed to finish connect", this.getServerAddress());
                        }
                        SSLEngine sslEngine = this.getSslContext().createSSLEngine(this.getServerAddress().getHost(), this.getServerAddress().getPort());
                        sslEngine.setUseClientMode(true);
                        SSLParameters sslParameters = sslEngine.getSSLParameters();
                        SslHelper.enableSni(this.getServerAddress().getHost(), sslParameters);
                        if (!this.sslSettings.isInvalidHostNameAllowed()) {
                            SslHelper.enableHostNameVerification(sslParameters);
                        }
                        sslEngine.setSSLParameters(sslParameters);
                        BufferProviderAllocator bufferAllocator = new BufferProviderAllocator();
                        ClientTlsChannel tlsChannel = ((ClientTlsChannel.Builder)((ClientTlsChannel.Builder)ClientTlsChannel.newBuilder((ByteChannel)socketChannel, sslEngine).withEncryptedBufferAllocator(bufferAllocator)).withPlainBufferAllocator(bufferAllocator)).build();
                        this.setChannel(new AsynchronousTlsChannelAdapter(new AsynchronousTlsChannel(this.group, tlsChannel, socketChannel)));
                        handler.completed(null);
                    }
                    catch (IOException e) {
                        handler.failed(new MongoSocketOpenException("Exception opening socket", this.getServerAddress(), (Throwable)e));
                    }
                    catch (Throwable t2) {
                        handler.failed(t2);
                    }
                });
            }
            catch (IOException e) {
                handler.failed(new MongoSocketOpenException("Exception opening socket", this.getServerAddress(), (Throwable)e));
            }
            catch (Throwable t2) {
                handler.failed(t2);
            }
        }

        private SSLContext getSslContext() {
            try {
                return Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                throw new MongoClientException("Unable to create default SSLContext", e);
            }
        }

        private class BufferProviderAllocator
        implements BufferAllocator {
            private BufferProviderAllocator() {
            }

            @Override
            public ByteBuffer allocate(int size) {
                return TlsChannelStream.this.getBufferProvider().getByteBuffer(size);
            }

            @Override
            public void free(ByteBuffer buffer) {
                TlsChannelStream.this.getBufferProvider().release(buffer);
            }
        }

        public static class AsynchronousTlsChannelAdapter
        implements ExtendedAsynchronousByteChannel {
            private final AsynchronousTlsChannel wrapped;

            AsynchronousTlsChannelAdapter(AsynchronousTlsChannel wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public <A> void read(ByteBuffer dst, A attach, CompletionHandler<Integer, ? super A> handler) {
                this.wrapped.read(dst, attach, handler);
            }

            @Override
            public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, @Nullable A attach, CompletionHandler<Integer, ? super A> handler) {
                this.wrapped.read(dst, timeout, unit, attach, handler);
            }

            @Override
            public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, @Nullable A attach, CompletionHandler<Long, ? super A> handler) {
                this.wrapped.read(dsts, offset, length, timeout, unit, attach, handler);
            }

            @Override
            public Future<Integer> read(ByteBuffer dst) {
                return this.wrapped.read(dst);
            }

            @Override
            public <A> void write(ByteBuffer src, A attach, CompletionHandler<Integer, ? super A> handler) {
                this.wrapped.write(src, attach, handler);
            }

            @Override
            public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attach, CompletionHandler<Integer, ? super A> handler) {
                this.wrapped.write(src, timeout, unit, attach, handler);
            }

            @Override
            public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attach, CompletionHandler<Long, ? super A> handler) {
                this.wrapped.write(srcs, offset, length, timeout, unit, attach, handler);
            }

            @Override
            public Future<Integer> write(ByteBuffer src) {
                return this.wrapped.write(src);
            }

            @Override
            public boolean isOpen() {
                return this.wrapped.isOpen();
            }

            @Override
            public void close() throws IOException {
                this.wrapped.close();
            }
        }
    }
}

