/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.model.TransactionType;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.NumberFormatting;
import xyz.harfull.nexuseco.util.PlayerUtils;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class EconomyCommand
implements CommandExecutor,
TabExecutor {
    private final EconomyManager economyManager;
    private final MessageManager messageManager;
    private final String permission;
    private final boolean enabled;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;

    public EconomyCommand(JavaPlugin plugin, EconomyManager economyManager, MessageManager messageManager) {
        this.plugin = (NexusEco)plugin;
        this.economyManager = economyManager;
        this.messageManager = messageManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.permission = plugin.getConfig().getString("commands.economy.permission", "nexuseco.economy");
        this.enabled = plugin.getConfig().getBoolean("commands.economy.enabled", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        if (!this.enabled) {
            return false;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!player.hasPermission(this.permission)) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
                this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
                return true;
            }
            if (strings.length == 0) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "economy.HELP", placeholders);
                this.messageManager.sendActionBar(player, "economy.HELP_ACTION_BAR", placeholders);
                return true;
            }
            switch (strings[0].toLowerCase()) {
                case "help": {
                    this.handleHelpCommand(player);
                    return true;
                }
                case "set": {
                    this.handleSetCommand(player, strings);
                    return true;
                }
                case "add": {
                    this.handleAddCommand(player, strings);
                    return true;
                }
                case "remove": {
                    this.handleRemoveCommand(player, strings);
                    return true;
                }
                case "reset": {
                    this.handleResetCommand(player, strings);
                    return true;
                }
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "economy.UNKNOWN_COMMAND", placeholders);
            this.messageManager.sendActionBar(player, "economy.UNKNOWN_COMMAND_ACTION_BAR", placeholders);
            return false;
        }
        sender.sendMessage(MessageManager.translateColors("&cThis command can only be used by players."));
        return false;
    }

    public void handleHelpCommand(Player player) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        this.messageManager.sendMessage(player, "economy.HELP", placeholders);
        this.messageManager.sendActionBar(player, "economy.HELP_ACTION_BAR", placeholders);
    }

    public void handleSetCommand(Player player, String[] args) {
        if (args.length < 3) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "economy.SET_USAGE", placeholders);
            this.messageManager.sendActionBar(player, "economy.SET_USAGE_ACTION_BAR", placeholders);
            return;
        }
        Player targetPlayer = player.getServer().getPlayerExact(args[1]);
        if (targetPlayer != null) {
            this.processSetCommand(player, (OfflinePlayer)targetPlayer, args[2]);
            return;
        }
        CompletableFuture<OfflinePlayer> future = PlayerUtils.findPlayerAsync(args[1]);
        future.thenAccept(target -> {
            if (target != null) {
                this.processSetCommand(player, (OfflinePlayer)target, args[2]);
            } else {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", args[1]);
                this.messageManager.sendMessage(player, "player.NOT_FOUND", placeholders);
                this.messageManager.sendActionBar(player, "player.NOT_FOUND_ACTION_BAR", placeholders);
            }
        });
    }

    private void processSetCommand(Player player, OfflinePlayer target, String amountStr) {
        double amount;
        try {
            amount = NumberFormatting.reverseFormatNum(amountStr);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "general.INVALID_AMOUNT", placeholders);
            this.messageManager.sendActionBar(player, "general.INVALID_AMOUNT_ACTION_BAR", placeholders);
            return;
        }
        UUID targetUUID = target.getUniqueId();
        double oldBalance = this.economyManager.getBalance(targetUUID);
        this.economyManager.setBalance(targetUUID, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("amount", NumberFormatting.formatNum(amount));
        this.messageManager.sendMessage(player, "economy.SET_SUCCESS", placeholders);
        this.messageManager.sendActionBar(player, "economy.SET_SUCCESS_ACTION_BAR", placeholders);
        CompletableFuture.runAsync(() -> {
            double difference = amount - oldBalance;
            TransactionType transactionType = difference < 0.0 ? TransactionType.ADMIN_DEDUCTED : TransactionType.ADMIN_RECEIVED;
            this.economyManager.createTransactionID(player.getUniqueId(), targetUUID, Math.abs(difference), transactionType);
        });
    }

    public void handleAddCommand(Player player, String[] args) {
        if (args.length < 3) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "economy.ADD_USAGE", placeholders);
            this.messageManager.sendActionBar(player, "economy.ADD_USAGE_ACTION_BAR", placeholders);
            return;
        }
        Player targetPlayer = player.getServer().getPlayerExact(args[1]);
        if (targetPlayer != null) {
            this.processAddCommand(player, (OfflinePlayer)targetPlayer, args[2]);
            return;
        }
        CompletableFuture<OfflinePlayer> future = PlayerUtils.findPlayerAsync(args[1]);
        future.thenAccept(target -> {
            if (target != null) {
                this.processAddCommand(player, (OfflinePlayer)target, args[2]);
            } else {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", args[1]);
                this.messageManager.sendMessage(player, "player.NOT_FOUND", placeholders);
                this.messageManager.sendActionBar(player, "player.NOT_FOUND_ACTION_BAR", placeholders);
            }
        });
    }

    private void processAddCommand(Player player, OfflinePlayer target, String amountStr) {
        double amount;
        try {
            amount = NumberFormatting.reverseFormatNum(amountStr);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "general.INVALID_AMOUNT", placeholders);
            this.messageManager.sendActionBar(player, "general.INVALID_AMOUNT_ACTION_BAR", placeholders);
            return;
        }
        UUID targetUUID = target.getUniqueId();
        this.economyManager.addBalance(targetUUID, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("amount", NumberFormatting.formatNum(amount));
        this.messageManager.sendMessage(player, "economy.ADD_SUCCESS", placeholders);
        this.messageManager.sendActionBar(player, "economy.ADD_SUCCESS_ACTION_BAR", placeholders);
        CompletableFuture.runAsync(() -> this.economyManager.createTransactionID(player.getUniqueId(), targetUUID, amount, TransactionType.ADMIN_RECEIVED));
    }

    public void handleRemoveCommand(Player player, String[] args) {
        if (args.length < 3) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "economy.REMOVE_USAGE", placeholders);
            this.messageManager.sendActionBar(player, "economy.REMOVE_USAGE_ACTION_BAR", placeholders);
            return;
        }
        Player targetPlayer = player.getServer().getPlayerExact(args[1]);
        if (targetPlayer != null) {
            this.processRemoveCommand(player, (OfflinePlayer)targetPlayer, args[2]);
            return;
        }
        CompletableFuture<OfflinePlayer> future = PlayerUtils.findPlayerAsync(args[1]);
        future.thenAccept(target -> {
            if (target != null) {
                this.processRemoveCommand(player, (OfflinePlayer)target, args[2]);
            } else {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", args[1]);
                this.messageManager.sendMessage(player, "player.NOT_FOUND", placeholders);
                this.messageManager.sendActionBar(player, "player.NOT_FOUND_ACTION_BAR", placeholders);
            }
        });
    }

    private void processRemoveCommand(Player player, OfflinePlayer target, String amountStr) {
        double amount;
        try {
            amount = NumberFormatting.reverseFormatNum(amountStr);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "general.INVALID_AMOUNT", placeholders);
            this.messageManager.sendActionBar(player, "general.INVALID_AMOUNT_ACTION_BAR", placeholders);
            return;
        }
        UUID targetUUID = target.getUniqueId();
        this.economyManager.subtractBalance(targetUUID, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("amount", NumberFormatting.formatNum(amount));
        this.messageManager.sendMessage(player, "economy.REMOVE_SUCCESS", placeholders);
        this.messageManager.sendActionBar(player, "economy.REMOVE_SUCCESS_ACTION_BAR", placeholders);
        CompletableFuture.runAsync(() -> this.economyManager.createTransactionID(player.getUniqueId(), targetUUID, amount, TransactionType.ADMIN_DEDUCTED));
    }

    public void handleResetCommand(Player player, String[] args) {
        if (args.length < 2) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "economy.RESET_USAGE", placeholders);
            this.messageManager.sendActionBar(player, "economy.RESET_USAGE_ACTION_BAR", placeholders);
            return;
        }
        Player targetPlayer = player.getServer().getPlayerExact(args[1]);
        if (targetPlayer != null) {
            this.processResetCommand(player, (OfflinePlayer)targetPlayer);
            return;
        }
        CompletableFuture<OfflinePlayer> future = PlayerUtils.findPlayerAsync(args[1]);
        future.thenAccept(target -> {
            if (target != null) {
                this.processResetCommand(player, (OfflinePlayer)target);
            } else {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", args[1]);
                this.messageManager.sendMessage(player, "player.NOT_FOUND", placeholders);
                this.messageManager.sendActionBar(player, "player.NOT_FOUND_ACTION_BAR", placeholders);
            }
        });
    }

    private void processResetCommand(Player player, OfflinePlayer target) {
        UUID targetUUID = target.getUniqueId();
        double oldBalance = this.economyManager.getBalance(targetUUID);
        this.economyManager.resetBalance(targetUUID);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        this.messageManager.sendMessage(player, "economy.RESET_SUCCESS", placeholders);
        this.messageManager.sendActionBar(player, "economy.RESET_SUCCESS_ACTION_BAR", placeholders);
        CompletableFuture.runAsync(() -> this.economyManager.createTransactionID(player.getUniqueId(), targetUUID, oldBalance, TransactionType.ADMIN_DEDUCTED));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        Player player;
        if (!(this.enabled && commandSender instanceof Player && (player = (Player)commandSender).hasPermission(this.permission))) {
            return null;
        }
        if (strings.length == 1) {
            return List.of("help", "set", "add", "remove", "reset");
        }
        if (strings.length == 2) {
            return commandSender.getServer().getOnlinePlayers().stream().map(OfflinePlayer::getName).toList();
        }
        if (strings.length == 3 && !strings[0].equalsIgnoreCase("reset")) {
            return List.of("100", "1000", "10000", "100000", "1000000");
        }
        return null;
    }
}

