/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.migration.MigrationManager;
import xyz.harfull.nexuseco.model.EconomyType;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class NexusEcoCommand
implements CommandExecutor,
TabExecutor {
    private final NexusEco nexusEco;
    private final MessageManager messageManager;
    private final TaskScheduler taskScheduler;
    private final MigrationManager migrationManager;
    private final String permission;

    public NexusEcoCommand(NexusEco nexusEco, MessageManager messageManager) {
        this.nexusEco = nexusEco;
        this.messageManager = messageManager;
        this.taskScheduler = nexusEco.getTaskScheduler();
        this.migrationManager = nexusEco.getMigrationManager();
        this.permission = nexusEco.getConfig().getString("commands.nexuseco.permission", "nexuseco.admin");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission(this.permission)) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                HashMap<String, String> placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
                this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
            } else {
                sender.sendMessage(MessageManager.translateColors("&cYou don't have permission to use this command."));
            }
            return true;
        }
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "version": {
                this.showVersion(sender);
                break;
            }
            case "reload": {
                this.reloadConfigs(sender);
                break;
            }
            case "migrate": {
                this.handleMigration(sender, args);
                break;
            }
            default: {
                this.showHelp(sender);
            }
        }
        return true;
    }

    private void showHelp(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "nexuseco.HELP", placeholders);
            this.messageManager.sendActionBar(player, "nexuseco.HELP_ACTION_BAR", placeholders);
        } else {
            sender.sendMessage(MessageManager.translateColors("&5/nexuseco &f<reload|version>"));
        }
    }

    private void showVersion(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("version", this.nexusEco.getDescription().getVersion());
            this.messageManager.sendMessage(player, "nexuseco.VERSION", placeholders);
            this.messageManager.sendActionBar(player, "nexuseco.VERSION_ACTION_BAR", placeholders);
        } else {
            sender.sendMessage(MessageManager.translateColors("&fVersion: &5" + this.nexusEco.getDescription().getVersion()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleMigration(CommandSender sender, String[] args) {
        block11: {
            block9: {
                block10: {
                    if (args.length < 2) {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            placeholders = new HashMap<String, String>();
                            this.messageManager.sendMessage(player, "nexuseco.MIGRATE_USAGE", placeholders);
                            this.messageManager.sendActionBar(player, "nexuseco.MIGRATE_USAGE_ACTION_BAR", placeholders);
                        } else {
                            sender.sendMessage(MessageManager.translateColors("&5/nexuseco &fmigrate <sourcePlugin> [--dry-run] [--force]"));
                        }
                        return;
                    }
                    dryRun = Arrays.stream(args).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleMigration$0(java.lang.String ), (Ljava/lang/String;)Z)());
                    force = Arrays.stream(args).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleMigration$1(java.lang.String ), (Ljava/lang/String;)Z)());
                    migrationName = args[1];
                    if (!migrationName.equalsIgnoreCase("essentialsx")) break block9;
                    v0 = isLoaded = this.nexusEco.getServer().getPluginManager().getPlugin("Essentials") != null;
                    if (isLoaded) break block10;
                    if (!(sender instanceof Player)) ** GOTO lbl-1000
                    player = (Player)sender;
                    if (this.messageManager != null) {
                        placeholders = new HashMap<String, String>();
                        placeholders.put("source", migrationName);
                        this.messageManager.sendMessage(player, "nexuseco.MIGRATE_NOT_FOUND", placeholders);
                        this.messageManager.sendActionBar(player, "nexuseco.MIGRATE_NOT_FOUND_ACTION_BAR", placeholders);
                    } else lbl-1000:
                    // 2 sources

                    {
                        sender.sendMessage(MessageManager.translateColors("&fPlugin &5" + migrationName + " &fis not found!"));
                    }
                    return;
                }
                if (!(sender instanceof Player)) ** GOTO lbl-1000
                player = (Player)sender;
                if (this.messageManager != null) {
                    placeholders = new HashMap<String, String>();
                    placeholders.put("source", migrationName);
                    placeholders.put("dryRun", String.valueOf(dryRun));
                    placeholders.put("force", String.valueOf(force));
                    this.messageManager.sendMessage(player, "nexuseco.MIGRATE_START", placeholders);
                    this.messageManager.sendActionBar(player, "nexuseco.MIGRATE_START_ACTION_BAR", placeholders);
                } else lbl-1000:
                // 2 sources

                {
                    sender.sendMessage(MessageManager.translateColors("&fStarting migration from &5" + migrationName + " &fwith dry run: &5" + dryRun + ", &fand force: &5" + force));
                }
                future = this.migrationManager.migrateAll(EconomyType.ESSENTIALS, dryRun, force);
                future.thenAccept((Consumer)(Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$handleMigration$2(org.bukkit.command.CommandSender java.lang.Integer ), (Ljava/lang/Integer;)V)((NexusEcoCommand)this, (CommandSender)sender));
                break block11;
            }
            if (sender instanceof Player) {
                player = (Player)sender;
                placeholders = new HashMap<String, String>();
                placeholders.put("source", migrationName);
                this.messageManager.sendMessage(player, "nexuseco.MIGRATE_INVALID", placeholders);
                this.messageManager.sendActionBar(player, "nexuseco.MIGRATE_INVALID_ACTION_BAR", placeholders);
            } else {
                sender.sendMessage(MessageManager.translateColors("&fInvalid migration source plugin: &5" + migrationName));
            }
        }
    }

    private void reloadConfigs(CommandSender sender) {
        try {
            this.taskScheduler.runTask(() -> this.lambda$reloadConfigs$3(sender));
        }
        catch (Exception e) {
            sender.sendMessage(MessageManager.translateColors("&cAn error occurred while reloading configuration files."));
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.nexusEco.getLogger().severe("Error reloading:\n" + String.valueOf(sw));
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("version");
            completions.add("reload");
            completions.add("migrate");
            return completions.stream().filter(s2 -> s2.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("migrate")) {
            completions.add("essentialsx");
            return completions.stream().filter(s2 -> s2.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length > 2 && args[0].equalsIgnoreCase("migrate")) {
            completions.add("--dry-run");
            completions.add("--force");
            return completions.stream().filter(s2 -> s2.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
        }
        return completions;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$reloadConfigs$3(CommandSender sender) {
        try {
            startTime = System.currentTimeMillis();
            this.nexusEco.reloadConfig();
            this.nexusEco.generateFiles();
            this.nexusEco.getHistoryGUI().reload();
            this.nexusEco.getProfileGUI().reload();
            this.nexusEco.getBaltopGUI().reload();
            if (this.messageManager != null) {
                this.messageManager.reload();
            }
            endTime = System.currentTimeMillis();
            duration = endTime - startTime;
            if (!(sender instanceof Player)) ** GOTO lbl-1000
            player = (Player)sender;
            if (this.messageManager != null) {
                placeholders = new HashMap<String, String>();
                placeholders.put("time", String.valueOf(duration));
                this.messageManager.sendMessage(player, "nexuseco.RELOAD", placeholders);
                this.messageManager.sendActionBar(player, "nexuseco.RELOAD_ACTION_BAR", placeholders);
            } else lbl-1000:
            // 2 sources

            {
                sender.sendMessage(MessageManager.translateColors("&fSuccessfully reloaded the configuration in &5" + duration + "ms"));
            }
        }
        catch (Exception e) {
            if (!(sender instanceof Player)) ** GOTO lbl-1000
            player = (Player)sender;
            if (this.messageManager != null) {
                placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "nexuseco.RELOAD_FAIL", placeholders);
                this.messageManager.sendActionBar(player, "nexuseco.RELOAD_FAIL_ACTION_BAR", placeholders);
            } else lbl-1000:
            // 2 sources

            {
                sender.sendMessage(MessageManager.translateColors("&cFailed to reload the configuration."));
            }
            sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.nexusEco.getLogger().severe("Error reloading:\n" + String.valueOf(sw));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ void lambda$handleMigration$2(CommandSender sender, Integer count) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.messageManager != null) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("count", String.valueOf(count));
                this.messageManager.sendMessage(player, "nexuseco.MIGRATE_SUCCESS", placeholders);
                this.messageManager.sendActionBar(player, "nexuseco.MIGRATE_SUCCESS_ACTION_BAR", placeholders);
                return;
            }
        }
        sender.sendMessage(MessageManager.translateColors("&fSuccessfully migrated &5" + count + " &fentries."));
    }

    private static /* synthetic */ boolean lambda$handleMigration$1(String arg) {
        return arg.equalsIgnoreCase("--force") || arg.equalsIgnoreCase("-f");
    }

    private static /* synthetic */ boolean lambda$handleMigration$0(String arg) {
        return arg.equalsIgnoreCase("--dry-run") || arg.equalsIgnoreCase("-d");
    }
}

