/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.model.TransactionType;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.NumberFormatting;
import xyz.harfull.nexuseco.util.PlayerUtils;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class PayCommand
implements CommandExecutor,
TabExecutor {
    private final EconomyManager economyManager;
    private final MessageManager messageManager;
    private final FileConfiguration config;
    private final String permission;
    private final boolean enabled;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;
    private final double minAmount;
    private final double maxAmount;
    private final boolean allowOfflinePayments;
    private final boolean logTransactions;

    public PayCommand(JavaPlugin plugin, EconomyManager economyManager, MessageManager messageManager) {
        this.plugin = (NexusEco)plugin;
        this.economyManager = economyManager;
        this.messageManager = messageManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.config = plugin.getConfig();
        this.permission = this.config.getString("commands.pay.permission", "nexuseco.pay");
        this.enabled = this.config.getBoolean("commands.pay.enabled", true);
        this.minAmount = this.config.getDouble("min-payment-amount", 1.0);
        this.maxAmount = this.config.getDouble("max-payment-amount", -1.0);
        this.allowOfflinePayments = this.config.getBoolean("allow-offline-payments", true);
        this.logTransactions = this.config.getBoolean("log-player-transactions", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s2, @NotNull String[] args) {
        if (!this.enabled) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageManager.translateColors("&cThis command can only be used by players."));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(this.permission)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
            this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
            return true;
        }
        if (args.length < 2) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "pay.HELP", placeholders);
            this.messageManager.sendActionBar(player, "pay.HELP_ACTION_BAR", placeholders);
            return true;
        }
        Player targetPlayer = Bukkit.getPlayerExact((String)args[0]);
        if (targetPlayer != null && targetPlayer.isOnline()) {
            this.processPayment(player, (OfflinePlayer)targetPlayer, args[1]);
            return true;
        }
        CompletableFuture<OfflinePlayer> future = PlayerUtils.findPlayerAsync(args[0]);
        future.thenAccept(target -> {
            if (target != null) {
                this.processPayment(player, (OfflinePlayer)target, args[1]);
            } else {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", args[0]);
                this.messageManager.sendMessage(player, "player.NOT_FOUND", placeholders);
                this.messageManager.sendActionBar(player, "player.NOT_FOUND_ACTION_BAR", placeholders);
            }
        });
        return true;
    }

    private void processPayment(Player sender, OfflinePlayer target, String amountStr) {
        double amount;
        UUID senderUUID = sender.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        if (!target.isOnline() && !this.allowOfflinePayments) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", target.getName());
            this.messageManager.sendMessage(sender, "pay.OFFLINE_PAYMENT_DISABLED", placeholders);
            this.messageManager.sendActionBar(sender, "pay.OFFLINE_PAYMENT_DISABLED_ACTION_BAR", placeholders);
            return;
        }
        if (targetUUID.equals(senderUUID)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(sender, "pay.SELF_PAY", placeholders);
            this.messageManager.sendActionBar(sender, "pay.SELF_PAY_ACTION_BAR", placeholders);
            return;
        }
        if (!this.economyManager.getPayToggle(targetUUID)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("target", target.getName());
            this.messageManager.sendMessage(sender, "pay.PAYMENT_DISABLED", placeholders);
            this.messageManager.sendActionBar(sender, "pay.PAYMENT_DISABLED_ACTION_BAR", placeholders);
            return;
        }
        try {
            amount = NumberFormatting.reverseFormatNum(amountStr);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(sender, "general.INVALID_AMOUNT", placeholders);
            this.messageManager.sendActionBar(sender, "general.INVALID_AMOUNT_ACTION_BAR", placeholders);
            return;
        }
        if (amount < this.minAmount) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("min", NumberFormatting.formatNum(this.minAmount));
            this.messageManager.sendMessage(sender, "pay.AMOUNT_TOO_SMALL", placeholders);
            this.messageManager.sendActionBar(sender, "pay.AMOUNT_TOO_SMALL_ACTION_BAR", placeholders);
            return;
        }
        if (this.maxAmount > 0.0 && amount > this.maxAmount && !sender.hasPermission(this.permission + ".bypass-limit")) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("max", NumberFormatting.formatNum(this.maxAmount));
            this.messageManager.sendMessage(sender, "pay.AMOUNT_TOO_LARGE", placeholders);
            this.messageManager.sendActionBar(sender, "pay.AMOUNT_TOO_LARGE_ACTION_BAR", placeholders);
            return;
        }
        if (!this.economyManager.hasBalance(senderUUID, amount)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(sender, "pay.NOT_ENOUGH", placeholders);
            this.messageManager.sendActionBar(sender, "pay.NOT_ENOUGH_ACTION_BAR", placeholders);
            return;
        }
        this.economyManager.subtractBalance(senderUUID, amount);
        this.economyManager.addBalance(targetUUID, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("amount", NumberFormatting.formatNum(amount));
        this.messageManager.sendMessage(sender, "pay.PAY_SUCCESS", placeholders);
        this.messageManager.sendActionBar(sender, "pay.PAY_SUCCESS_ACTION_BAR", placeholders);
        CompletableFuture.runAsync(() -> {
            if (this.logTransactions) {
                String logMessage = String.format("[NexusEco] %s paid %s to %s", sender.getName(), NumberFormatting.formatNum(amount), target.getName());
                Bukkit.getLogger().info(logMessage);
            }
            this.economyManager.createTransactionID(senderUUID, targetUUID, amount, TransactionType.SENT);
            this.economyManager.createTransactionID(senderUUID, targetUUID, amount, TransactionType.RECEIVED);
        });
        if (target.isOnline()) {
            Player targetPlayer = (Player)target;
            HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
            targetPlaceholders.put("player", sender.getName());
            targetPlaceholders.put("amount", NumberFormatting.formatNum(amount));
            this.messageManager.sendMessage(targetPlayer, "pay.RECEIVED", targetPlaceholders);
            this.messageManager.sendActionBar(targetPlayer, "pay.RECEIVED_ACTION_BAR", targetPlaceholders);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s2, @NotNull String[] args) {
        Player player;
        if (!(this.enabled && sender instanceof Player && (player = (Player)sender).hasPermission(this.permission))) {
            return null;
        }
        if (args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).toList();
        }
        if (args.length == 2) {
            return List.of("100", "1k", "100k", "1m", "10m");
        }
        return null;
    }
}

