/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class PayToggle
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final MessageManager messageManager;
    private final EconomyManager economyManager;
    private final TaskScheduler taskScheduler;
    private final String permission;
    private final boolean enabled;

    public PayToggle(JavaPlugin plugin) {
        this.plugin = plugin;
        NexusEco nexusEco = (NexusEco)plugin;
        this.messageManager = nexusEco.getMessageManager();
        this.economyManager = nexusEco.getEconomyManager();
        this.taskScheduler = nexusEco.getTaskScheduler();
        this.permission = plugin.getConfig().getString("commands.pay_toggle.permission", "nexuseco.pay_toggle");
        this.enabled = plugin.getConfig().getBoolean("commands.pay_toggle.enabled", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.enabled) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageManager.translateColors("&cThis command can only be used by players."));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(this.permission)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
            this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
            return true;
        }
        boolean payToggle = !this.economyManager.getPayToggle(player.getUniqueId());
        this.economyManager.setPayToggle(player.getUniqueId(), payToggle);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (payToggle) {
            this.messageManager.sendMessage(player, "pay_toggle.SUCCESS_RECEIVING", placeholders);
            this.messageManager.sendActionBar(player, "pay_toggle.SUCCESS_RECEIVING_ACTION_BAR", placeholders);
        } else {
            this.messageManager.sendMessage(player, "pay_toggle.SUCCESS_NOT_RECEIVING", placeholders);
            this.messageManager.sendActionBar(player, "pay_toggle.SUCCESS_NOT_RECEIVING_ACTION_BAR", placeholders);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player player;
        if (!(this.enabled && sender instanceof Player && (player = (Player)sender).hasPermission(this.permission))) {
            return null;
        }
        return List.of();
    }
}

