/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.data;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.data.DataMethods;
import xyz.harfull.nexuseco.data.storage.MongoDBStorage;
import xyz.harfull.nexuseco.data.storage.MySQLStorage;
import xyz.harfull.nexuseco.data.storage.SQLiteStorage;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private static DataMethods dataMethods;
    private final FileConfiguration databaseConfig;
    private final String databaseType;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
        File databaseFile = new File(plugin.getDataFolder(), "database.yml");
        this.databaseConfig = YamlConfiguration.loadConfiguration((File)databaseFile);
        this.databaseType = this.databaseConfig.getString("Database.Database-Type", "sqlite").toLowerCase();
    }

    public void initializeDatabase() {
        switch (this.databaseType) {
            case "sqlite": {
                dataMethods = new SQLiteStorage(this.plugin);
                break;
            }
            case "mysql": {
                dataMethods = new MySQLStorage(this.plugin, this.databaseConfig);
                break;
            }
            case "mongodb": {
                dataMethods = new MongoDBStorage(this.plugin, this.databaseConfig);
                break;
            }
            default: {
                this.plugin.getLogger().warning("Unsupported database type: " + this.databaseType);
            }
        }
    }

    public static DataMethods getEconomyMethods() {
        return dataMethods;
    }
}

