/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.data.storage;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.data.DataMethods;
import xyz.harfull.nexuseco.model.PlayerBalance;
import xyz.harfull.nexuseco.model.TransactionID;
import xyz.harfull.nexuseco.model.TransactionType;

public class MongoDBStorage
implements DataMethods {
    private final JavaPlugin plugin;
    private final FileConfiguration databaseConfig;
    private MongoClient mongoClient;
    private MongoCollection<Document> balanceCollection;
    private MongoCollection<Document> transactionHistoryCollection;
    private MongoCollection<Document> playerSettingsCollection;

    public MongoDBStorage(JavaPlugin plugin, FileConfiguration databaseConfig) {
        this.plugin = plugin;
        this.databaseConfig = databaseConfig;
        this.init();
    }

    private void init() {
        try {
            String uri = this.databaseConfig.getString("Database.MongoDB.uri", "mongodb://localhost:27017");
            String databaseName = this.databaseConfig.getString("Database.MongoDB.database", "nexuseco");
            this.mongoClient = MongoClients.create(uri);
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(databaseName);
            this.balanceCollection = mongoDatabase.getCollection("player_balance");
            this.transactionHistoryCollection = mongoDatabase.getCollection("transaction_history");
            this.playerSettingsCollection = mongoDatabase.getCollection("player_settings");
            this.plugin.getLogger().info("Successfully connected to MongoDB!");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error connecting to MongoDB:\n" + String.valueOf(sw));
        }
    }

    @Override
    public PlayerBalance getBalance(UUID playerId) {
        Document document = (Document)this.balanceCollection.find(new Document("UUID", playerId.toString())).first();
        if (document != null) {
            double balance = document.getDouble("balance");
            return new PlayerBalance(playerId, balance);
        }
        return new PlayerBalance(playerId, 0.0);
    }

    @Override
    public void setBalance(UUID playerId, double amount) {
        Document query = new Document("UUID", playerId.toString());
        Document update = new Document("$set", new Document("balance", amount));
        this.balanceCollection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
    }

    @Override
    public void addBalance(UUID playerId, double amount) {
        Document query = new Document("UUID", playerId.toString());
        Document update = new Document("$inc", new Document("balance", amount));
        this.balanceCollection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
    }

    @Override
    public void subtractBalance(UUID playerId, double amount) {
        Document query = new Document("UUID", playerId.toString());
        Document update = new Document("$inc", new Document("balance", -amount));
        this.balanceCollection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
    }

    @Override
    public void createTransactionID(UUID senderId, UUID receiverId, double amount, TransactionType transactionType, String transactionID) {
        Document transaction = new Document("transaction_id", transactionID).append("receiver_uuid", receiverId.toString()).append("sender_uuid", senderId.toString()).append("amount", amount).append("transaction_type", transactionType.name()).append("transaction_time", new Date());
        this.transactionHistoryCollection.insertOne(transaction);
    }

    @Override
    public TransactionID getTransactionID(String transactionID) {
        Document query = new Document("transaction_id", transactionID);
        Document result = (Document)this.transactionHistoryCollection.find(query).first();
        if (result != null) {
            UUID receiverUUID = UUID.fromString(result.getString("receiver_uuid"));
            UUID senderUUID = UUID.fromString(result.getString("sender_uuid"));
            double amount = result.getDouble("amount");
            TransactionType transactionType = TransactionType.valueOf(result.getString("transaction_type"));
            Date transactionTime = result.getDate("transaction_time");
            return new TransactionID(receiverUUID, senderUUID, amount, transactionType, transactionID, new Timestamp(transactionTime.getTime()));
        }
        return null;
    }

    @Override
    public List<TransactionID> getTransactionHistory(UUID playerId) {
        List documents = this.transactionHistoryCollection.find(new Document("receiver_uuid", playerId.toString())).into(new ArrayList());
        ArrayList<TransactionID> transactions = new ArrayList<TransactionID>();
        for (Document document : documents) {
            UUID receiverUUID = UUID.fromString(document.getString("receiver_uuid"));
            UUID senderUUID = UUID.fromString(document.getString("sender_uuid"));
            double amount = document.getDouble("amount");
            TransactionType transactionType = TransactionType.valueOf(document.getString("transaction_type"));
            String transactionID = document.getString("transaction_id");
            Date transactionTime = document.getDate("transaction_time");
            transactions.add(new TransactionID(receiverUUID, senderUUID, amount, transactionType, transactionID, new Timestamp(transactionTime.getTime())));
        }
        return transactions;
    }

    @Override
    public Map<UUID, Double> getAllBalances() {
        List documents = this.balanceCollection.find().into(new ArrayList());
        HashMap<UUID, Double> balances = new HashMap<UUID, Double>();
        for (Document document : documents) {
            UUID playerId = UUID.fromString(document.getString("UUID"));
            double balance = document.getDouble("balance");
            balances.put(playerId, balance);
        }
        return balances;
    }

    @Override
    public void setPayToggle(UUID playerId, boolean toggle) {
        Document query = new Document("UUID", playerId.toString());
        Document update = new Document("$set", new Document("toggle_receive", toggle));
        this.playerSettingsCollection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
    }

    @Override
    public boolean getPayToggle(UUID playerId) {
        Document document = (Document)this.playerSettingsCollection.find(new Document("UUID", playerId.toString())).first();
        if (document != null) {
            return document.getBoolean("toggle_receive", false);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }
}

