/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.data.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.data.DataMethods;
import xyz.harfull.nexuseco.model.PlayerBalance;
import xyz.harfull.nexuseco.model.TransactionID;
import xyz.harfull.nexuseco.model.TransactionType;

public class MySQLStorage
implements DataMethods {
    private final JavaPlugin plugin;
    private final FileConfiguration databaseConfig;
    private HikariDataSource hikariDataSource;

    public MySQLStorage(JavaPlugin plugin, FileConfiguration databaseConfig) {
        this.plugin = plugin;
        this.databaseConfig = databaseConfig;
        this.init();
    }

    public void init() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + this.databaseConfig.getString("Database.MySQL.host") + ":" + this.databaseConfig.getString("Database.MySQL.port") + "/" + this.databaseConfig.getString("Database.MySQL.database"));
        config.setUsername(this.databaseConfig.getString("Database.MySQL.user"));
        config.setPassword(this.databaseConfig.getString("Database.MySQL.password"));
        config.setMaximumPoolSize(this.databaseConfig.getInt("Database.MySQL.max-pool"));
        config.addDataSourceProperty("useSSL", this.databaseConfig.getBoolean("Database.MySQL.use-ssl"));
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        config.addDataSourceProperty("useServerPrepStmts", "true");
        this.hikariDataSource = new HikariDataSource(config);
        try (Connection connection = this.hikariDataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS player_balance (UUID VARCHAR(36) PRIMARY KEY, balance DOUBLE)");
            statement.execute("CREATE TABLE IF NOT EXISTS transaction_history (transaction_id TEXT PRIMARY KEY, receiver_uuid VARCHAR(36) NOT NULL, sender_uuid VARCHAR(36) NOT NULL, amount DOUBLE NOT NULL, transaction_type VARCHAR(32) NOT NULL, transaction_time DATETIME DEFAULT CURRENT_TIMESTAMP)");
            statement.execute("CREATE TABLE IF NOT EXISTS player_settings (UUID VARCHAR(36) PRIMARY KEY, toggle_receive BOOLEAN DEFAULT 0)");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error connecting to MySQL:\n" + String.valueOf(sw));
        }
    }

    @Override
    public void close() {
        if (this.hikariDataSource != null) {
            this.hikariDataSource.close();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public PlayerBalance getBalance(UUID playerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setBalance(UUID playerId, double amount) {
        try (Connection connection = this.hikariDataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO player_balance (UUID, balance) VALUES (?, ?) ON DUPLICATE KEY UPDATE balance = VALUES(balance)");){
            statement.setString(1, playerId.toString());
            statement.setDouble(2, amount);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error setting balance:\n" + String.valueOf(sw));
        }
    }

    @Override
    public void addBalance(UUID playerId, double amount) {
        try (Connection connection = this.hikariDataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("UPDATE player_balance SET balance = balance + ? WHERE UUID = ?");){
            statement.setDouble(1, amount);
            statement.setString(2, playerId.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error adding balance:\n" + String.valueOf(sw));
        }
    }

    @Override
    public void subtractBalance(UUID playerId, double amount) {
        try (Connection connection = this.hikariDataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("UPDATE player_balance SET balance = balance - ? WHERE UUID = ?");){
            statement.setDouble(1, amount);
            statement.setString(2, playerId.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error subtracting balance:\n" + String.valueOf(sw));
        }
    }

    @Override
    public void createTransactionID(UUID senderId, UUID receiverId, double amount, TransactionType transactionType, String transactionID) {
        try (Connection connection = this.hikariDataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO transaction_history (transaction_id, receiver_uuid, sender_uuid, amount, transaction_type, transaction_time) VALUES (?, ?, ?, ?, ?, ?)");){
            statement.setString(1, transactionID);
            statement.setString(2, receiverId.toString());
            statement.setString(3, senderId.toString());
            statement.setDouble(4, amount);
            statement.setString(5, transactionType.name());
            statement.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error creating transaction ID:\n" + String.valueOf(sw));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransactionID getTransactionID(String transactionID) {
        try (Connection connection = this.hikariDataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM transaction_history WHERE transaction_id = ?");){
            statement.setString(1, transactionID);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                UUID receiverUUID = UUID.fromString(resultSet.getString("receiver_uuid"));
                UUID senderUUID = UUID.fromString(resultSet.getString("sender_uuid"));
                double amount = resultSet.getDouble("amount");
                TransactionType transactionType = TransactionType.valueOf(resultSet.getString("transaction_type"));
                Timestamp transactionTime = resultSet.getTimestamp("transaction_time");
                TransactionID transactionID2 = new TransactionID(receiverUUID, senderUUID, amount, transactionType, transactionID, new Timestamp(transactionTime.getTime()));
                return transactionID2;
            }
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error getting transaction ID:\n" + String.valueOf(sw));
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TransactionID> getTransactionHistory(UUID playerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<UUID, Double> getAllBalances() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setPayToggle(UUID playerId, boolean toggleReceive) {
        try (Connection connection = this.hikariDataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO player_settings (UUID, toggle_receive) VALUES (?, ?) ON DUPLICATE KEY UPDATE toggle_receive = ?");){
            statement.setString(1, playerId.toString());
            statement.setBoolean(2, toggleReceive);
            statement.setBoolean(3, toggleReceive);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error setting pay toggle:\n" + String.valueOf(sw));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getPayToggle(UUID playerId) {
        try (Connection connection = this.hikariDataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT toggle_receive FROM player_settings WHERE UUID = ?");){
            statement.setString(1, playerId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return false;
                boolean bl = resultSet.getBoolean("toggle_receive");
                return bl;
            }
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.plugin.getLogger().severe("Error getting pay toggle:\n" + String.valueOf(sw));
        }
        return false;
    }
}

