/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.gui.ProfileGUI;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.NumberFormatting;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class BaltopGUI
implements Listener {
    private final EconomyManager economyManager;
    private YamlConfiguration config;
    private final ProfileGUI profileGUI;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;
    private final File baltopUIFile;
    private int size;
    private final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private List<Map.Entry<UUID, Double>> topBalances = new ArrayList<Map.Entry<UUID, Double>>();
    private long lastUpdateTime = 0L;
    private final long CACHE_DURATION;

    public BaltopGUI(JavaPlugin plugin, EconomyManager economyManager, File baltopUIFile, ProfileGUI profileGUI) {
        this.plugin = (NexusEco)plugin;
        this.baltopUIFile = baltopUIFile;
        this.economyManager = economyManager;
        this.profileGUI = profileGUI;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.config = YamlConfiguration.loadConfiguration((File)baltopUIFile);
        this.size = this.config.getInt("gui-size", 54);
        if (this.size % 9 != 0 || this.size < 9 || this.size > 54) {
            throw new IllegalArgumentException("Invalid GUI size. Must be multiple of 9 between 9 and 54");
        }
        this.CACHE_DURATION = this.config.getLong("cache-duration", 300L) * 1000L;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void reload() {
        this.playerPages.clear();
        this.topBalances.clear();
        this.lastUpdateTime = 0L;
        this.config = YamlConfiguration.loadConfiguration((File)this.baltopUIFile);
        this.size = this.config.getInt("gui-size", 54);
        if (this.size % 9 != 0 || this.size < 9 || this.size > 54) {
            throw new IllegalArgumentException("Invalid GUI size. Must be multiple of 9 between 9 and 54");
        }
    }

    public void open(Player player) {
        this.open(player, 1);
    }

    public void open(Player player, int page) {
        int maxPages;
        UUID uuid = player.getUniqueId();
        if (System.currentTimeMillis() - this.lastUpdateTime > this.CACHE_DURATION || this.topBalances.isEmpty()) {
            this.loadTopBalances();
        }
        page = Math.max(1, Math.min(page, (maxPages = this.calculateMaxPages()) > 0 ? maxPages : 1));
        this.playerPages.put(uuid, page);
        String rawTitle = this.config.getString("title", "&8Balance Top {page}/{max-page}");
        Component title = MessageManager.translateColors(rawTitle.replace("{page}", String.valueOf(page)).replace("{max-page}", String.valueOf(Math.max(1, maxPages))));
        int finalPage = page;
        this.taskScheduler.runEntityTask((Entity)player, p -> {
            Inventory inv = Bukkit.createInventory(null, (int)this.size, (Component)title);
            this.addFiller(inv);
            this.addButtons(inv, finalPage, maxPages);
            this.addEntries(inv, player, finalPage);
            player.openInventory(inv);
        });
    }

    private void loadTopBalances() {
        this.taskScheduler.runTaskAsync(() -> {
            Map<UUID, Double> all = this.economyManager.getAllBalances();
            this.topBalances = new ArrayList<Map.Entry<UUID, Double>>(all.entrySet());
            this.topBalances.sort(Map.Entry.comparingByValue().reversed());
            this.lastUpdateTime = System.currentTimeMillis();
        });
    }

    private int calculateMaxPages() {
        int[] range = this.parseRange(this.config.getString("items.leaderboard-entry.slot-range", "0-44"));
        int perPage = range[1] - range[0] + 1;
        return this.topBalances.isEmpty() ? 0 : (int)Math.ceil((double)this.topBalances.size() / (double)perPage);
    }

    private void addFiller(Inventory inv) {
        ConfigurationSection sec = this.config.getConfigurationSection("filler");
        if (sec == null) {
            return;
        }
        ItemStack item = this.createItem(Material.valueOf((String)sec.getString("material", "GRAY_STAINED_GLASS_PANE")), sec.getString("name", " "), sec.getStringList("lore"));
        int[] r = this.parseRange(sec.getString("slot-range", ""));
        for (int i = r[0]; i <= r[1] && i < this.size; ++i) {
            inv.setItem(i, item);
        }
    }

    private void addButtons(Inventory inv, int page, int max) {
        this.addButton(inv, "previous-page", page > 1);
        this.addButton(inv, "next-page", page < max);
        this.addButton(inv, "refresh", true);
        this.addButton(inv, "close", true);
    }

    private void addButton(Inventory inv, String key, boolean condition) {
        if (!condition) {
            return;
        }
        ConfigurationSection sec = this.config.getConfigurationSection("items." + key);
        if (sec == null) {
            return;
        }
        int slot = sec.getInt("slot");
        if (slot < 0 || slot >= this.size) {
            return;
        }
        ItemStack item = this.createItem(Material.valueOf((String)sec.getString("material")), sec.getString("name"), sec.getStringList("lore"));
        inv.setItem(slot, item);
    }

    private void addEntries(Inventory inv, Player player, int page) {
        if (this.topBalances.isEmpty()) {
            return;
        }
        int[] range = this.parseRange(this.config.getString("items.leaderboard-entry.slot-range", "0-44"));
        int perPage = range[1] - range[0] + 1;
        int start = (page - 1) * perPage;
        int end = Math.min(start + perPage, this.topBalances.size());
        int slot = range[0];
        int i = start;
        while (i < end) {
            Map.Entry<UUID, Double> e = this.topBalances.get(i);
            inv.setItem(slot, this.createEntry(e.getKey(), e.getValue(), i + 1));
            ++i;
            ++slot;
        }
    }

    private ItemStack createEntry(UUID id, double balance, int rank) {
        SkullMeta skullMeta;
        ItemStack item;
        ConfigurationSection sec = this.config.getConfigurationSection("items.leaderboard-entry");
        if (sec == null) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)id);
        String name = Optional.ofNullable(op.getName()).orElse("Unknown");
        if (name == null) {
            name = "Unknown";
        }
        String display = sec.getString("name", "#{rank} {player}").replace("{rank}", String.valueOf(rank)).replace("{player}", name);
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : sec.getStringList("lore")) {
            lore.add(line.replace("{rank}", String.valueOf(rank)).replace("{player}", name).replace("{balance}", NumberFormatting.formatNum(balance)));
        }
        try {
            item = new ItemStack(Material.valueOf((String)sec.getString("material", "PLAYER_HEAD")));
        }
        catch (IllegalArgumentException ex) {
            item = new ItemStack(Material.PLAYER_HEAD);
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(MessageManager.translateColors(display));
            ArrayList<Component> compLore = new ArrayList<Component>();
            for (String line : lore) {
                compLore.add(MessageManager.translateColors(line));
            }
            meta.lore(compLore);
            item.setItemMeta(meta);
        }
        if (item.getType() == Material.PLAYER_HEAD && (skullMeta = (SkullMeta)item.getItemMeta()) != null) {
            if (op.hasPlayedBefore()) {
                skullMeta.setOwningPlayer(op);
            } else {
                skullMeta.setDisplayName(name);
            }
            item.setItemMeta((ItemMeta)skullMeta);
        }
        return item;
    }

    private int[] parseRange(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return new int[]{0, 0};
        }
        String[] p = s2.split("-");
        try {
            return new int[]{Integer.parseInt(p[0]), p.length > 1 ? Integer.parseInt(p[1]) : Integer.parseInt(p[0])};
        }
        catch (NumberFormatException ex) {
            return new int[]{0, 0};
        }
    }

    private ItemStack createItem(Material mat, String name, List<String> lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(MessageManager.translateColors(name));
            if (!lore.isEmpty()) {
                ArrayList compLore = new ArrayList();
                lore.forEach(l -> compLore.add(MessageManager.translateColors(l)));
                meta.lore(compLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        int perPage;
        int start;
        int clickedIndex;
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.playerPages.containsKey(player.getUniqueId())) {
            return;
        }
        int slot = e.getSlot();
        e.setCancelled(true);
        int currentPage = this.playerPages.getOrDefault(player.getUniqueId(), 1);
        int[] entryRange = this.parseRange(this.config.getString("items.leaderboard-entry.slot-range", "0-44"));
        if (slot >= entryRange[0] && slot <= entryRange[1] && (clickedIndex = (start = (currentPage - 1) * (perPage = entryRange[1] - entryRange[0] + 1)) + (slot - entryRange[0])) >= 0 && clickedIndex < this.topBalances.size()) {
            UUID targetUUID = this.topBalances.get(clickedIndex).getKey();
            OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((UUID)targetUUID);
            this.taskScheduler.runEntityTask((Entity)player, p -> {
                player.closeInventory();
                if (this.profileGUI != null) {
                    this.profileGUI.open(player, targetPlayer);
                }
            });
            return;
        }
        ConfigurationSection prevSection = this.config.getConfigurationSection("items.previous-page");
        if (prevSection != null && slot == prevSection.getInt("slot")) {
            if (currentPage > 1) {
                this.taskScheduler.runEntityTask((Entity)player, p -> this.open(player, currentPage - 1));
            }
            return;
        }
        ConfigurationSection nextSection = this.config.getConfigurationSection("items.next-page");
        if (nextSection != null && slot == nextSection.getInt("slot")) {
            int maxPages = this.calculateMaxPages();
            if (currentPage < maxPages) {
                this.taskScheduler.runEntityTask((Entity)player, p -> this.open(player, currentPage + 1));
            }
            return;
        }
        ConfigurationSection refreshSection = this.config.getConfigurationSection("items.refresh");
        if (refreshSection != null && slot == refreshSection.getInt("slot")) {
            this.lastUpdateTime = 0L;
            this.taskScheduler.runEntityTask((Entity)player, p -> this.open(player, currentPage));
            return;
        }
        ConfigurationSection closeSection = this.config.getConfigurationSection("items.close");
        if (closeSection != null && slot == closeSection.getInt("slot")) {
            this.taskScheduler.runEntityTask((Entity)player, p -> player.closeInventory());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        HumanEntity humanEntity = e.getPlayer();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            this.playerPages.remove(p.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.playerPages.remove(e.getPlayer().getUniqueId());
    }
}

