/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.NumberFormatting;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class ProfileGUI
implements Listener {
    private final EconomyManager economyManager;
    private YamlConfiguration config;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;
    private final File profileUIFile;
    private int size;
    private final Map<UUID, UUID> viewingProfiles = new HashMap<UUID, UUID>();

    public ProfileGUI(JavaPlugin plugin, EconomyManager economyManager, File profileUIFile) {
        this.plugin = (NexusEco)plugin;
        this.profileUIFile = profileUIFile;
        this.economyManager = economyManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.config = YamlConfiguration.loadConfiguration((File)profileUIFile);
        this.size = this.config.getInt("gui-size", 27);
        if (this.size % 9 != 0 || this.size < 9 || this.size > 54) {
            throw new IllegalArgumentException("Invalid GUI size. Must be multiple of 9 between 9 and 54");
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.profileUIFile);
        this.size = this.config.getInt("gui-size", 54);
        if (this.size % 9 != 0 || this.size < 9 || this.size > 54) {
            throw new IllegalArgumentException("Invalid GUI size. Must be multiple of 9 between 9 and 54");
        }
    }

    public void open(Player viewer, OfflinePlayer target) {
        UUID viewerUUID = viewer.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        this.viewingProfiles.put(viewerUUID, targetUUID);
        String rawTitle = this.config.getString("title", "&8{player}'s Profile");
        Component title = MessageManager.translateColors(rawTitle.replace("{player}", target.getName() != null ? target.getName() : "Unknown"));
        this.taskScheduler.runEntityTask((Entity)viewer, p -> {
            Inventory inv = Bukkit.createInventory(null, (int)this.size, (Component)title);
            this.addFiller(inv);
            this.addProfileItems(inv, target);
            viewer.openInventory(inv);
        });
    }

    private void addFiller(Inventory inv) {
        ConfigurationSection sec = this.config.getConfigurationSection("filler");
        if (sec == null) {
            return;
        }
        ItemStack item = this.createItem(Material.valueOf((String)sec.getString("material", "GRAY_STAINED_GLASS_PANE")), sec.getString("name", " "), sec.getStringList("lore"));
        int[] r = this.parseRange(sec.getString("slot-range", ""));
        for (int i = r[0]; i <= r[1] && i < this.size; ++i) {
            inv.setItem(i, item);
        }
    }

    private void addProfileItems(Inventory inv, OfflinePlayer targetPlayer) {
        UUID targetUUID = targetPlayer.getUniqueId();
        this.addProfileItem(inv, "player-head", targetPlayer);
        double balance = this.economyManager.getBalance(targetUUID);
        this.addProfileItem(inv, "balance-info", targetPlayer, balance);
        this.addProfileItem(inv, "close", targetPlayer);
        this.addProfileItem(inv, "pay-button", targetPlayer);
    }

    private void addProfileItem(Inventory inv, String key, OfflinePlayer player) {
        this.addProfileItem(inv, key, player, 0.0);
    }

    private void addProfileItem(Inventory inv, String key, OfflinePlayer player, double balance) {
        Material material;
        ConfigurationSection sec = this.config.getConfigurationSection("items." + key);
        if (sec == null) {
            return;
        }
        int slot = sec.getInt("slot", -1);
        if (slot < 0 || slot >= this.size) {
            return;
        }
        String materialName = sec.getString("material", "PLAYER_HEAD");
        try {
            material = Material.valueOf((String)materialName);
        }
        catch (IllegalArgumentException e) {
            material = Material.STONE;
        }
        String name = sec.getString("name", "&f{player}");
        List lore = sec.getStringList("lore");
        ItemStack item = this.createProfileItemStack(material, name, lore, player, balance);
        inv.setItem(slot, item);
    }

    private ItemStack createProfileItemStack(Material material, String name, List<String> lore, OfflinePlayer player, double balance) {
        SkullMeta skullMeta;
        ItemStack item = new ItemStack(material);
        String playerName = player.getName() != null ? player.getName() : "Unknown";
        name = name.replace("{player}", playerName).replace("{balance}", NumberFormatting.formatNum(balance));
        ArrayList<String> processedLore = new ArrayList<String>();
        for (String line : lore) {
            processedLore.add(line.replace("{player}", playerName).replace("{balance}", NumberFormatting.formatNum(balance)));
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(MessageManager.translateColors(name));
            ArrayList<Component> compLore = new ArrayList<Component>();
            for (String line : processedLore) {
                compLore.add(MessageManager.translateColors(line));
            }
            meta.lore(compLore);
            item.setItemMeta(meta);
        }
        if (material == Material.PLAYER_HEAD && player.hasPlayedBefore() && (skullMeta = (SkullMeta)item.getItemMeta()) != null) {
            skullMeta.setOwningPlayer(player);
            item.setItemMeta((ItemMeta)skullMeta);
        }
        return item;
    }

    private int[] parseRange(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return new int[]{0, 0};
        }
        String[] p = s2.split("-");
        try {
            return new int[]{Integer.parseInt(p[0]), p.length > 1 ? Integer.parseInt(p[1]) : Integer.parseInt(p[0])};
        }
        catch (NumberFormatException ex) {
            return new int[]{0, 0};
        }
    }

    private ItemStack createItem(Material mat, String name, List<String> lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(MessageManager.translateColors(name));
            if (!lore.isEmpty()) {
                ArrayList compLore = new ArrayList();
                lore.forEach(l -> compLore.add(MessageManager.translateColors(l)));
                meta.lore(compLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.viewingProfiles.containsKey(player.getUniqueId())) {
            return;
        }
        UUID targetUUID = this.viewingProfiles.get(player.getUniqueId());
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((UUID)targetUUID);
        int slot = e.getSlot();
        e.setCancelled(true);
        ConfigurationSection closeSection = this.config.getConfigurationSection("items.close");
        if (closeSection != null && slot == closeSection.getInt("slot")) {
            this.taskScheduler.runEntityTask((Entity)player, p -> player.closeInventory());
            return;
        }
        ConfigurationSection paySection = this.config.getConfigurationSection("items.pay-button");
        if (paySection != null && slot == paySection.getInt("slot") && !player.getUniqueId().equals(targetUUID)) {
            this.taskScheduler.runEntityTask((Entity)player, p -> {
                player.closeInventory();
                player.performCommand("pay " + targetPlayer.getName());
            });
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        HumanEntity humanEntity = e.getPlayer();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            this.viewingProfiles.remove(p.getUniqueId());
        }
    }
}

