/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.util;

import java.io.File;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class MessageManager {
    private final NexusEco plugin;
    private final TaskScheduler taskScheduler;
    private FileConfiguration messagesConfig;
    private Component prefix;

    public MessageManager(JavaPlugin plugin) {
        this.plugin = (NexusEco)plugin;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.setup();
    }

    private void setup() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)file);
        this.prefix = MessageManager.translateColors(this.messagesConfig.getString("prefix", ""));
    }

    public void reload() {
        this.setup();
    }

    public Component get(String path, boolean usePrefix) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return ((TextComponent.Builder)Component.text().color(TextColor.fromHexString((String)"#ff0000"))).content("Message not found: " + path).build();
        }
        return this.format(message, usePrefix);
    }

    public static Component translateColors(String message) {
        if (message == null) {
            return null;
        }
        return LegacyComponentSerializer.legacyAmpersand().deserialize(message).decoration(TextDecoration.ITALIC, false);
    }

    public Component format(String message, boolean usePrefix) {
        if (message == null) {
            return null;
        }
        Component colored = MessageManager.translateColors(message);
        if (usePrefix) {
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.prefix)).append(colored)).build();
        }
        return colored;
    }

    public void sendMessage(Player player, String path, Map<String, String> placeholders) {
        Component message = this.get(path, true);
        if (message.equals((Object)Component.text((String)""))) {
            return;
        }
        Component finalMessage = message = this.replacePlaceholders(message, placeholders);
        this.taskScheduler.runEntityTask((Entity)player, p -> p.sendMessage(finalMessage));
    }

    public void sendActionBar(Player player, String path, Map<String, String> placeholders) {
        Component message = this.get(path, false);
        if (message.equals((Object)Component.text((String)""))) {
            return;
        }
        Component finalMessage = message = this.replacePlaceholders(message, placeholders);
        this.taskScheduler.runEntityTask((Entity)player, p -> p.sendActionBar(finalMessage));
    }

    private Component replacePlaceholders(Component message, Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String placeholder = entry.getKey();
            String replacement = entry.getValue();
            message = message.replaceText(builder -> builder.match("\\{" + placeholder + "\\}").replacement(replacement));
        }
        return message;
    }
}

