/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.util;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class PlayerUtils {
    private static NexusEco plugin;
    private static TaskScheduler taskScheduler;

    public static void init(JavaPlugin mainPlugin) {
        plugin = (NexusEco)mainPlugin;
        taskScheduler = plugin.getTaskScheduler();
    }

    public static CompletableFuture<OfflinePlayer> findPlayerAsync(String name) {
        CompletableFuture<OfflinePlayer> future = new CompletableFuture<OfflinePlayer>();
        if (taskScheduler != null) {
            taskScheduler.runTaskAsync(() -> {
                OfflinePlayer result = PlayerUtils.findPlayer(name);
                future.complete(result);
            });
        } else {
            CompletableFuture.supplyAsync(() -> PlayerUtils.findPlayer(name)).thenAccept(future::complete);
        }
        return future;
    }

    private static OfflinePlayer findPlayer(String name) {
        Player onlinePlayer = Bukkit.getPlayerExact((String)name);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(name)) continue;
            return player;
        }
        try {
            OfflinePlayer[] uuid = UUID.fromString(name);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            if (offlinePlayer.hasPlayedBefore()) {
                return offlinePlayer;
            }
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            if (offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(name) || !offlinePlayer.hasPlayedBefore()) continue;
            return offlinePlayer;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)name);
        if (offlinePlayer.hasPlayedBefore()) {
            return offlinePlayer;
        }
        return null;
    }
}

