/*
 * Decompiled with CFR 0.152.
 */
package com.enchantedwisp.torchesbt;

import com.enchantedwisp.torchesbt.blockentity.ModBlockEntities;
import com.enchantedwisp.torchesbt.compat.CompatRegistryHandler;
import com.enchantedwisp.torchesbt.compat.CompatResourceLoader;
import com.enchantedwisp.torchesbt.config.RealisticTorchesBTConfig;
import com.enchantedwisp.torchesbt.core.burn.BurnTimeManager;
import com.enchantedwisp.torchesbt.core.fuel.FuelTypeLoader;
import com.enchantedwisp.torchesbt.core.ignition.ReignitionHandler;
import com.enchantedwisp.torchesbt.network.ItemFuelPacket;
import com.enchantedwisp.torchesbt.registry.Particles;
import com.enchantedwisp.torchesbt.registry.RegistryHandler;
import com.enchantedwisp.torchesbt.util.ConfigCache;
import com.enchantedwisp.torchesbt.util.OptionalResourceLoader;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealisticTorchesBT
implements ModInitializer {
    public static final String MOD_ID = "torchesbt";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"torchesbt");
    private static ConfigHolder<RealisticTorchesBTConfig> configHolder;
    private static RealisticTorchesBTConfig config;

    public static RealisticTorchesBTConfig getConfig() {
        return config;
    }

    public static void saveConfig() {
        try {
            configHolder.save();
        }
        catch (Exception e) {
            LOGGER.error("Failed to save RealisticTorchesBTConfig to config/torchesbt.json5", (Throwable)e);
        }
    }

    public void onInitialize() {
        LOGGER.info("Initializing Realistic Torches BT");
        OptionalResourceLoader.loadOptionalResources();
        try {
            configHolder = AutoConfig.register(RealisticTorchesBTConfig.class, JanksonConfigSerializer::new);
            config = (RealisticTorchesBTConfig)configHolder.getConfig();
        }
        catch (Exception e) {
            LOGGER.error("Failed to deserialize RealisticTorchesBTConfig from config/torchesbt.json5, falling back to defaults", (Throwable)e);
            config = new RealisticTorchesBTConfig();
            configHolder = AutoConfig.getConfigHolder(RealisticTorchesBTConfig.class);
        }
        ConfigCache.initialize();
        FuelTypeLoader.register();
        ItemFuelPacket.register();
        RegistryHandler.register();
        ModBlockEntities.register();
        RegistryHandler.registerBurnables();
        CompatRegistryHandler.registerChipped();
        CompatRegistryHandler.registerTrinkets();
        CompatResourceLoader.register();
        Particles.register();
        ReignitionHandler.register();
        BurnTimeManager.register();
    }
}

